/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceResponse;
import software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberOrder;
import software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberOrderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPhoneNumberOrdersResponse
extends ChimeSdkVoiceResponse
implements ToCopyableBuilder<Builder, ListPhoneNumberOrdersResponse> {
    private static final SdkField<List<PhoneNumberOrder>> PHONE_NUMBER_ORDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberOrders").getter(ListPhoneNumberOrdersResponse.getter(ListPhoneNumberOrdersResponse::phoneNumberOrders)).setter(ListPhoneNumberOrdersResponse.setter(Builder::phoneNumberOrders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberOrders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumberOrder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPhoneNumberOrdersResponse.getter(ListPhoneNumberOrdersResponse::nextToken)).setter(ListPhoneNumberOrdersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ORDERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PhoneNumberOrders", PHONE_NUMBER_ORDERS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<PhoneNumberOrder> phoneNumberOrders;
    private final String nextToken;

    private ListPhoneNumberOrdersResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberOrders = builder.phoneNumberOrders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPhoneNumberOrders() {
        return this.phoneNumberOrders != null && !(this.phoneNumberOrders instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumberOrder> phoneNumberOrders() {
        return this.phoneNumberOrders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberOrders() ? this.phoneNumberOrders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumberOrdersResponse)) {
            return false;
        }
        ListPhoneNumberOrdersResponse other = (ListPhoneNumberOrdersResponse)((Object)obj);
        return this.hasPhoneNumberOrders() == other.hasPhoneNumberOrders() && Objects.equals(this.phoneNumberOrders(), other.phoneNumberOrders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPhoneNumberOrdersResponse").add("PhoneNumberOrders", this.hasPhoneNumberOrders() ? this.phoneNumberOrders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberOrders": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberOrders()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumberOrdersResponse, T> g) {
        return obj -> g.apply((ListPhoneNumberOrdersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceResponse.BuilderImpl
    implements Builder {
        private List<PhoneNumberOrder> phoneNumberOrders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumberOrdersResponse model) {
            super(model);
            this.phoneNumberOrders(model.phoneNumberOrders);
            this.nextToken(model.nextToken);
        }

        public final List<PhoneNumberOrder.Builder> getPhoneNumberOrders() {
            List<PhoneNumberOrder.Builder> result = PhoneNumberOrderListCopier.copyToBuilder(this.phoneNumberOrders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhoneNumberOrders(Collection<PhoneNumberOrder.BuilderImpl> phoneNumberOrders) {
            this.phoneNumberOrders = PhoneNumberOrderListCopier.copyFromBuilder(phoneNumberOrders);
        }

        @Override
        public final Builder phoneNumberOrders(Collection<PhoneNumberOrder> phoneNumberOrders) {
            this.phoneNumberOrders = PhoneNumberOrderListCopier.copy(phoneNumberOrders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberOrders(PhoneNumberOrder ... phoneNumberOrders) {
            this.phoneNumberOrders(Arrays.asList(phoneNumberOrders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberOrders(Consumer<PhoneNumberOrder.Builder> ... phoneNumberOrders) {
            this.phoneNumberOrders(Stream.of(phoneNumberOrders).map(c -> (PhoneNumberOrder)((PhoneNumberOrder.Builder)PhoneNumberOrder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPhoneNumberOrdersResponse build() {
            return new ListPhoneNumberOrdersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPhoneNumberOrdersResponse> {
        public Builder phoneNumberOrders(Collection<PhoneNumberOrder> var1);

        public Builder phoneNumberOrders(PhoneNumberOrder ... var1);

        public Builder phoneNumberOrders(Consumer<PhoneNumberOrder.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

