/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummary;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelAssociatedWithFlowSummaryListCopier;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelsAssociatedWithChannelFlowResponse
extends ChimeSdkMessagingResponse
implements ToCopyableBuilder<Builder, ListChannelsAssociatedWithChannelFlowResponse> {
    private static final SdkField<List<ChannelAssociatedWithFlowSummary>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Channels").getter(ListChannelsAssociatedWithChannelFlowResponse.getter(ListChannelsAssociatedWithChannelFlowResponse::channels)).setter(ListChannelsAssociatedWithChannelFlowResponse.setter(Builder::channels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChannelAssociatedWithFlowSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChannelsAssociatedWithChannelFlowResponse.getter(ListChannelsAssociatedWithChannelFlowResponse::nextToken)).setter(ListChannelsAssociatedWithChannelFlowResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNELS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListChannelsAssociatedWithChannelFlowResponse.memberNameToFieldInitializer();
    private final List<ChannelAssociatedWithFlowSummary> channels;
    private final String nextToken;

    private ListChannelsAssociatedWithChannelFlowResponse(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<ChannelAssociatedWithFlowSummary> channels() {
        return this.channels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelsAssociatedWithChannelFlowResponse)) {
            return false;
        }
        ListChannelsAssociatedWithChannelFlowResponse other = (ListChannelsAssociatedWithChannelFlowResponse)((Object)obj);
        return this.hasChannels() == other.hasChannels() && Objects.equals(this.channels(), other.channels()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChannelsAssociatedWithChannelFlowResponse").add("Channels", this.hasChannels() ? this.channels() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Channels", CHANNELS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListChannelsAssociatedWithChannelFlowResponse, T> g) {
        return obj -> g.apply((ListChannelsAssociatedWithChannelFlowResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingResponse.BuilderImpl
    implements Builder {
        private List<ChannelAssociatedWithFlowSummary> channels = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelsAssociatedWithChannelFlowResponse model) {
            super(model);
            this.channels(model.channels);
            this.nextToken(model.nextToken);
        }

        public final List<ChannelAssociatedWithFlowSummary.Builder> getChannels() {
            List<ChannelAssociatedWithFlowSummary.Builder> result = ChannelAssociatedWithFlowSummaryListCopier.copyToBuilder(this.channels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannels(Collection<ChannelAssociatedWithFlowSummary.BuilderImpl> channels) {
            this.channels = ChannelAssociatedWithFlowSummaryListCopier.copyFromBuilder(channels);
        }

        @Override
        public final Builder channels(Collection<ChannelAssociatedWithFlowSummary> channels) {
            this.channels = ChannelAssociatedWithFlowSummaryListCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(ChannelAssociatedWithFlowSummary ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Consumer<ChannelAssociatedWithFlowSummary.Builder> ... channels) {
            this.channels(Stream.of(channels).map(c -> (ChannelAssociatedWithFlowSummary)((ChannelAssociatedWithFlowSummary.Builder)ChannelAssociatedWithFlowSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChannelsAssociatedWithChannelFlowResponse build() {
            return new ListChannelsAssociatedWithChannelFlowResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkMessagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChannelsAssociatedWithChannelFlowResponse> {
        public Builder channels(Collection<ChannelAssociatedWithFlowSummary> var1);

        public Builder channels(ChannelAssociatedWithFlowSummary ... var1);

        public Builder channels(Consumer<ChannelAssociatedWithFlowSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

