/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChannelMessageCallback;
import software.amazon.awssdk.services.chimesdkmessaging.model.ChimeSdkMessagingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelFlowCallbackRequest
extends ChimeSdkMessagingRequest
implements ToCopyableBuilder<Builder, ChannelFlowCallbackRequest> {
    private static final SdkField<String> CALLBACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallbackId").getter(ChannelFlowCallbackRequest.getter(ChannelFlowCallbackRequest::callbackId)).setter(ChannelFlowCallbackRequest.setter(Builder::callbackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(ChannelFlowCallbackRequest.getter(ChannelFlowCallbackRequest::channelArn)).setter(ChannelFlowCallbackRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()}).build();
    private static final SdkField<Boolean> DELETE_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteResource").getter(ChannelFlowCallbackRequest.getter(ChannelFlowCallbackRequest::deleteResource)).setter(ChannelFlowCallbackRequest.setter(Builder::deleteResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteResource").build()}).build();
    private static final SdkField<ChannelMessageCallback> CHANNEL_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChannelMessage").getter(ChannelFlowCallbackRequest.getter(ChannelFlowCallbackRequest::channelMessage)).setter(ChannelFlowCallbackRequest.setter(Builder::channelMessage)).constructor(ChannelMessageCallback::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLBACK_ID_FIELD, CHANNEL_ARN_FIELD, DELETE_RESOURCE_FIELD, CHANNEL_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChannelFlowCallbackRequest.memberNameToFieldInitializer();
    private final String callbackId;
    private final String channelArn;
    private final Boolean deleteResource;
    private final ChannelMessageCallback channelMessage;

    private ChannelFlowCallbackRequest(BuilderImpl builder) {
        super(builder);
        this.callbackId = builder.callbackId;
        this.channelArn = builder.channelArn;
        this.deleteResource = builder.deleteResource;
        this.channelMessage = builder.channelMessage;
    }

    public final String callbackId() {
        return this.callbackId;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final Boolean deleteResource() {
        return this.deleteResource;
    }

    public final ChannelMessageCallback channelMessage() {
        return this.channelMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.callbackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelFlowCallbackRequest)) {
            return false;
        }
        ChannelFlowCallbackRequest other = (ChannelFlowCallbackRequest)((Object)obj);
        return Objects.equals(this.callbackId(), other.callbackId()) && Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.deleteResource(), other.deleteResource()) && Objects.equals(this.channelMessage(), other.channelMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelFlowCallbackRequest").add("CallbackId", (Object)this.callbackId()).add("ChannelArn", (Object)this.channelArn()).add("DeleteResource", (Object)this.deleteResource()).add("ChannelMessage", (Object)this.channelMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallbackId": {
                return Optional.ofNullable(clazz.cast(this.callbackId()));
            }
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "DeleteResource": {
                return Optional.ofNullable(clazz.cast(this.deleteResource()));
            }
            case "ChannelMessage": {
                return Optional.ofNullable(clazz.cast(this.channelMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CallbackId", CALLBACK_ID_FIELD);
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("DeleteResource", DELETE_RESOURCE_FIELD);
        map.put("ChannelMessage", CHANNEL_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChannelFlowCallbackRequest, T> g) {
        return obj -> g.apply((ChannelFlowCallbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkMessagingRequest.BuilderImpl
    implements Builder {
        private String callbackId;
        private String channelArn;
        private Boolean deleteResource;
        private ChannelMessageCallback channelMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelFlowCallbackRequest model) {
            super(model);
            this.callbackId(model.callbackId);
            this.channelArn(model.channelArn);
            this.deleteResource(model.deleteResource);
            this.channelMessage(model.channelMessage);
        }

        public final String getCallbackId() {
            return this.callbackId;
        }

        public final void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @Override
        public final Builder callbackId(String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final Boolean getDeleteResource() {
            return this.deleteResource;
        }

        public final void setDeleteResource(Boolean deleteResource) {
            this.deleteResource = deleteResource;
        }

        @Override
        public final Builder deleteResource(Boolean deleteResource) {
            this.deleteResource = deleteResource;
            return this;
        }

        public final ChannelMessageCallback.Builder getChannelMessage() {
            return this.channelMessage != null ? this.channelMessage.toBuilder() : null;
        }

        public final void setChannelMessage(ChannelMessageCallback.BuilderImpl channelMessage) {
            this.channelMessage = channelMessage != null ? channelMessage.build() : null;
        }

        @Override
        public final Builder channelMessage(ChannelMessageCallback channelMessage) {
            this.channelMessage = channelMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ChannelFlowCallbackRequest build() {
            return new ChannelFlowCallbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ChannelFlowCallbackRequest> {
        public Builder callbackId(String var1);

        public Builder channelArn(String var1);

        public Builder deleteResource(Boolean var1);

        public Builder channelMessage(ChannelMessageCallback var1);

        default public Builder channelMessage(Consumer<ChannelMessageCallback.Builder> channelMessage) {
            return this.channelMessage((ChannelMessageCallback)((ChannelMessageCallback.Builder)ChannelMessageCallback.builder().applyMutation(channelMessage)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

