/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.MessagingDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamingConfiguration> {
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataType").getter(StreamingConfiguration.getter(StreamingConfiguration::dataTypeAsString)).setter(StreamingConfiguration.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(StreamingConfiguration.getter(StreamingConfiguration::resourceArn)).setter(StreamingConfiguration.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TYPE_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StreamingConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataType;
    private final String resourceArn;

    private StreamingConfiguration(BuilderImpl builder) {
        this.dataType = builder.dataType;
        this.resourceArn = builder.resourceArn;
    }

    public final MessagingDataType dataType() {
        return MessagingDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingConfiguration)) {
            return false;
        }
        StreamingConfiguration other = (StreamingConfiguration)obj;
        return Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"StreamingConfiguration").add("DataType", (Object)this.dataTypeAsString()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DataType", DATA_TYPE_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamingConfiguration, T> g) {
        return obj -> g.apply((StreamingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataType;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingConfiguration model) {
            this.dataType(model.dataType);
            this.resourceArn(model.resourceArn);
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(MessagingDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public StreamingConfiguration build() {
            return new StreamingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamingConfiguration> {
        public Builder dataType(String var1);

        public Builder dataType(MessagingDataType var1);

        public Builder resourceArn(String var1);
    }
}

