/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingAsyncClient;
import software.amazon.awssdk.services.chimesdkmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListSubChannelsRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListSubChannelsResponse;

public class ListSubChannelsPublisher
implements SdkPublisher<ListSubChannelsResponse> {
    private final ChimeSdkMessagingAsyncClient client;
    private final ListSubChannelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubChannelsPublisher(ChimeSdkMessagingAsyncClient client, ListSubChannelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubChannelsPublisher(ChimeSdkMessagingAsyncClient client, ListSubChannelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubChannelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubChannelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSubChannelsResponseFetcher
    implements AsyncPageFetcher<ListSubChannelsResponse> {
        private ListSubChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubChannelsResponse> nextPage(ListSubChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListSubChannelsPublisher.this.client.listSubChannels(ListSubChannelsPublisher.this.firstRequest);
            }
            return ListSubChannelsPublisher.this.client.listSubChannels((ListSubChannelsRequest)((Object)ListSubChannelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

