/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmessaging.model.ExpirationCriterion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpirationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpirationSettings> {
    private static final SdkField<Integer> EXPIRATION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpirationDays").getter(ExpirationSettings.getter(ExpirationSettings::expirationDays)).setter(ExpirationSettings.setter(Builder::expirationDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDays").build()}).build();
    private static final SdkField<String> EXPIRATION_CRITERION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpirationCriterion").getter(ExpirationSettings.getter(ExpirationSettings::expirationCriterionAsString)).setter(ExpirationSettings.setter(Builder::expirationCriterion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationCriterion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_DAYS_FIELD, EXPIRATION_CRITERION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExpirationSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer expirationDays;
    private final String expirationCriterion;

    private ExpirationSettings(BuilderImpl builder) {
        this.expirationDays = builder.expirationDays;
        this.expirationCriterion = builder.expirationCriterion;
    }

    public final Integer expirationDays() {
        return this.expirationDays;
    }

    public final ExpirationCriterion expirationCriterion() {
        return ExpirationCriterion.fromValue(this.expirationCriterion);
    }

    public final String expirationCriterionAsString() {
        return this.expirationCriterion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationCriterionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpirationSettings)) {
            return false;
        }
        ExpirationSettings other = (ExpirationSettings)obj;
        return Objects.equals(this.expirationDays(), other.expirationDays()) && Objects.equals(this.expirationCriterionAsString(), other.expirationCriterionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExpirationSettings").add("ExpirationDays", (Object)this.expirationDays()).add("ExpirationCriterion", (Object)this.expirationCriterionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExpirationDays": {
                return Optional.ofNullable(clazz.cast(this.expirationDays()));
            }
            case "ExpirationCriterion": {
                return Optional.ofNullable(clazz.cast(this.expirationCriterionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExpirationDays", EXPIRATION_DAYS_FIELD);
        map.put("ExpirationCriterion", EXPIRATION_CRITERION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpirationSettings, T> g) {
        return obj -> g.apply((ExpirationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer expirationDays;
        private String expirationCriterion;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpirationSettings model) {
            this.expirationDays(model.expirationDays);
            this.expirationCriterion(model.expirationCriterion);
        }

        public final Integer getExpirationDays() {
            return this.expirationDays;
        }

        public final void setExpirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
        }

        @Override
        public final Builder expirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
            return this;
        }

        public final String getExpirationCriterion() {
            return this.expirationCriterion;
        }

        public final void setExpirationCriterion(String expirationCriterion) {
            this.expirationCriterion = expirationCriterion;
        }

        @Override
        public final Builder expirationCriterion(String expirationCriterion) {
            this.expirationCriterion = expirationCriterion;
            return this;
        }

        @Override
        public final Builder expirationCriterion(ExpirationCriterion expirationCriterion) {
            this.expirationCriterion(expirationCriterion == null ? null : expirationCriterion.toString());
            return this;
        }

        public ExpirationSettings build() {
            return new ExpirationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpirationSettings> {
        public Builder expirationDays(Integer var1);

        public Builder expirationCriterion(String var1);

        public Builder expirationCriterion(ExpirationCriterion var1);
    }
}

