/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingAsyncClient;
import software.amazon.awssdk.services.chimesdkmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelFlowsResponse;

public class ListChannelFlowsPublisher
implements SdkPublisher<ListChannelFlowsResponse> {
    private final ChimeSdkMessagingAsyncClient client;
    private final ListChannelFlowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelFlowsPublisher(ChimeSdkMessagingAsyncClient client, ListChannelFlowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelFlowsPublisher(ChimeSdkMessagingAsyncClient client, ListChannelFlowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelFlowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelFlowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListChannelFlowsResponseFetcher
    implements AsyncPageFetcher<ListChannelFlowsResponse> {
        private ListChannelFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelFlowsResponse> nextPage(ListChannelFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelFlowsPublisher.this.client.listChannelFlows(ListChannelFlowsPublisher.this.firstRequest);
            }
            return ListChannelFlowsPublisher.this.client.listChannelFlows((ListChannelFlowsRequest)((Object)ListChannelFlowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

