/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutChannelMembershipPreferencesRequest extends ChimeSdkMessagingRequest implements
        ToCopyableBuilder<PutChannelMembershipPreferencesRequest.Builder, PutChannelMembershipPreferencesRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(PutChannelMembershipPreferencesRequest::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()).build();

    private static final SdkField<String> MEMBER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberArn").getter(getter(PutChannelMembershipPreferencesRequest::memberArn))
            .setter(setter(Builder::memberArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("memberArn").build()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(PutChannelMembershipPreferencesRequest::chimeBearer))
            .setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final SdkField<ChannelMembershipPreferences> PREFERENCES_FIELD = SdkField
            .<ChannelMembershipPreferences> builder(MarshallingType.SDK_POJO).memberName("Preferences")
            .getter(getter(PutChannelMembershipPreferencesRequest::preferences)).setter(setter(Builder::preferences))
            .constructor(ChannelMembershipPreferences::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preferences").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            MEMBER_ARN_FIELD, CHIME_BEARER_FIELD, PREFERENCES_FIELD));

    private final String channelArn;

    private final String memberArn;

    private final String chimeBearer;

    private final ChannelMembershipPreferences preferences;

    private PutChannelMembershipPreferencesRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.memberArn = builder.memberArn;
        this.chimeBearer = builder.chimeBearer;
        this.preferences = builder.preferences;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The ARN of the member setting the preferences.
     * </p>
     * 
     * @return The ARN of the member setting the preferences.
     */
    public final String memberArn() {
        return memberArn;
    }

    /**
     * <p>
     * The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
     * </p>
     * 
     * @return The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    /**
     * <p>
     * The channel membership preferences of an <code>AppInstanceUser</code> .
     * </p>
     * 
     * @return The channel membership preferences of an <code>AppInstanceUser</code> .
     */
    public final ChannelMembershipPreferences preferences() {
        return preferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(memberArn());
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        hashCode = 31 * hashCode + Objects.hashCode(preferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutChannelMembershipPreferencesRequest)) {
            return false;
        }
        PutChannelMembershipPreferencesRequest other = (PutChannelMembershipPreferencesRequest) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(memberArn(), other.memberArn())
                && Objects.equals(chimeBearer(), other.chimeBearer()) && Objects.equals(preferences(), other.preferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutChannelMembershipPreferencesRequest").add("ChannelArn", channelArn())
                .add("MemberArn", memberArn()).add("ChimeBearer", chimeBearer()).add("Preferences", preferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "MemberArn":
            return Optional.ofNullable(clazz.cast(memberArn()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        case "Preferences":
            return Optional.ofNullable(clazz.cast(preferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutChannelMembershipPreferencesRequest, T> g) {
        return obj -> g.apply((PutChannelMembershipPreferencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeSdkMessagingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutChannelMembershipPreferencesRequest> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The ARN of the member setting the preferences.
         * </p>
         * 
         * @param memberArn
         *        The ARN of the member setting the preferences.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberArn(String memberArn);

        /**
         * <p>
         * The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        /**
         * <p>
         * The channel membership preferences of an <code>AppInstanceUser</code> .
         * </p>
         * 
         * @param preferences
         *        The channel membership preferences of an <code>AppInstanceUser</code> .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferences(ChannelMembershipPreferences preferences);

        /**
         * <p>
         * The channel membership preferences of an <code>AppInstanceUser</code> .
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelMembershipPreferences.Builder}
         * avoiding the need to create one manually via {@link ChannelMembershipPreferences#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelMembershipPreferences.Builder#build()} is called
         * immediately and its result is passed to {@link #preferences(ChannelMembershipPreferences)}.
         * 
         * @param preferences
         *        a consumer that will call methods on {@link ChannelMembershipPreferences.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preferences(ChannelMembershipPreferences)
         */
        default Builder preferences(Consumer<ChannelMembershipPreferences.Builder> preferences) {
            return preferences(ChannelMembershipPreferences.builder().applyMutation(preferences).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeSdkMessagingRequest.BuilderImpl implements Builder {
        private String channelArn;

        private String memberArn;

        private String chimeBearer;

        private ChannelMembershipPreferences preferences;

        private BuilderImpl() {
        }

        private BuilderImpl(PutChannelMembershipPreferencesRequest model) {
            super(model);
            channelArn(model.channelArn);
            memberArn(model.memberArn);
            chimeBearer(model.chimeBearer);
            preferences(model.preferences);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getMemberArn() {
            return memberArn;
        }

        public final void setMemberArn(String memberArn) {
            this.memberArn = memberArn;
        }

        @Override
        public final Builder memberArn(String memberArn) {
            this.memberArn = memberArn;
            return this;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        public final ChannelMembershipPreferences.Builder getPreferences() {
            return preferences != null ? preferences.toBuilder() : null;
        }

        public final void setPreferences(ChannelMembershipPreferences.BuilderImpl preferences) {
            this.preferences = preferences != null ? preferences.build() : null;
        }

        @Override
        public final Builder preferences(ChannelMembershipPreferences preferences) {
            this.preferences = preferences;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutChannelMembershipPreferencesRequest build() {
            return new PutChannelMembershipPreferencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
