/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The push notification configuration of the message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PushNotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PushNotificationConfiguration.Builder, PushNotificationConfiguration> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(PushNotificationConfiguration::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Body")
            .getter(getter(PushNotificationConfiguration::body)).setter(setter(Builder::body))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(PushNotificationConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, BODY_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String body;

    private final String type;

    private PushNotificationConfiguration(BuilderImpl builder) {
        this.title = builder.title;
        this.body = builder.body;
        this.type = builder.type;
    }

    /**
     * <p>
     * The title of the push notification.
     * </p>
     * 
     * @return The title of the push notification.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The body of the push notification.
     * </p>
     * 
     * @return The body of the push notification.
     */
    public final String body() {
        return body;
    }

    /**
     * <p>
     * Enum value that indicates the type of the push notification for a message. <code>DEFAULT</code>: Normal mobile
     * push notification. <code>VOIP</code>: VOIP mobile push notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PushNotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Enum value that indicates the type of the push notification for a message. <code>DEFAULT</code>: Normal
     *         mobile push notification. <code>VOIP</code>: VOIP mobile push notification.
     * @see PushNotificationType
     */
    public final PushNotificationType type() {
        return PushNotificationType.fromValue(type);
    }

    /**
     * <p>
     * Enum value that indicates the type of the push notification for a message. <code>DEFAULT</code>: Normal mobile
     * push notification. <code>VOIP</code>: VOIP mobile push notification.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link PushNotificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Enum value that indicates the type of the push notification for a message. <code>DEFAULT</code>: Normal
     *         mobile push notification. <code>VOIP</code>: VOIP mobile push notification.
     * @see PushNotificationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(body());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushNotificationConfiguration)) {
            return false;
        }
        PushNotificationConfiguration other = (PushNotificationConfiguration) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(body(), other.body())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PushNotificationConfiguration")
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Body", body() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Body":
            return Optional.ofNullable(clazz.cast(body()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PushNotificationConfiguration, T> g) {
        return obj -> g.apply((PushNotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PushNotificationConfiguration> {
        /**
         * <p>
         * The title of the push notification.
         * </p>
         * 
         * @param title
         *        The title of the push notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The body of the push notification.
         * </p>
         * 
         * @param body
         *        The body of the push notification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(String body);

        /**
         * <p>
         * Enum value that indicates the type of the push notification for a message. <code>DEFAULT</code>: Normal
         * mobile push notification. <code>VOIP</code>: VOIP mobile push notification.
         * </p>
         * 
         * @param type
         *        Enum value that indicates the type of the push notification for a message. <code>DEFAULT</code>:
         *        Normal mobile push notification. <code>VOIP</code>: VOIP mobile push notification.
         * @see PushNotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PushNotificationType
         */
        Builder type(String type);

        /**
         * <p>
         * Enum value that indicates the type of the push notification for a message. <code>DEFAULT</code>: Normal
         * mobile push notification. <code>VOIP</code>: VOIP mobile push notification.
         * </p>
         * 
         * @param type
         *        Enum value that indicates the type of the push notification for a message. <code>DEFAULT</code>:
         *        Normal mobile push notification. <code>VOIP</code>: VOIP mobile push notification.
         * @see PushNotificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PushNotificationType
         */
        Builder type(PushNotificationType type);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String body;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(PushNotificationConfiguration model) {
            title(model.title);
            body(model.body);
            type(model.type);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getBody() {
            return body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(PushNotificationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public PushNotificationConfiguration build() {
            return new PushNotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
