/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingAsyncClient;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMessagesRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMessagesResponse;

public class ListChannelMessagesPublisher
implements SdkPublisher<ListChannelMessagesResponse> {
    private final ChimeSdkMessagingAsyncClient client;
    private final ListChannelMessagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelMessagesPublisher(ChimeSdkMessagingAsyncClient client, ListChannelMessagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelMessagesPublisher(ChimeSdkMessagingAsyncClient client, ListChannelMessagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelMessagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelMessagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListChannelMessagesResponseFetcher
    implements AsyncPageFetcher<ListChannelMessagesResponse> {
        private ListChannelMessagesResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelMessagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelMessagesResponse> nextPage(ListChannelMessagesResponse previousPage) {
            if (previousPage == null) {
                return ListChannelMessagesPublisher.this.client.listChannelMessages(ListChannelMessagesPublisher.this.firstRequest);
            }
            return ListChannelMessagesPublisher.this.client.listChannelMessages((ListChannelMessagesRequest)((Object)ListChannelMessagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

