/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChannelMessageCallback
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChannelMessageCallback> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(ChannelMessageCallback.getter(ChannelMessageCallback::messageId)).setter(ChannelMessageCallback.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(ChannelMessageCallback.getter(ChannelMessageCallback::content)).setter(ChannelMessageCallback.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(ChannelMessageCallback.getter(ChannelMessageCallback::metadata)).setter(ChannelMessageCallback.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, CONTENT_FIELD, METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final String content;
    private final String metadata;

    private ChannelMessageCallback(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.content = builder.content;
        this.metadata = builder.metadata;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final String content() {
        return this.content;
    }

    public final String metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelMessageCallback)) {
            return false;
        }
        ChannelMessageCallback other = (ChannelMessageCallback)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"ChannelMessageCallback").add("MessageId", (Object)this.messageId()).add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelMessageCallback, T> g) {
        return obj -> g.apply((ChannelMessageCallback)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private String content;
        private String metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelMessageCallback model) {
            this.messageId(model.messageId);
            this.content(model.content);
            this.metadata(model.metadata);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        @Transient
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        @Transient
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public ChannelMessageCallback build() {
            return new ChannelMessageCallback(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChannelMessageCallback> {
        public Builder messageId(String var1);

        public Builder content(String var1);

        public Builder metadata(String var1);
    }
}

