/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingClient;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelModeratorsResponse;

public class ListChannelModeratorsIterable
implements SdkIterable<ListChannelModeratorsResponse> {
    private final ChimeSdkMessagingClient client;
    private final ListChannelModeratorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelModeratorsIterable(ChimeSdkMessagingClient client, ListChannelModeratorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListChannelModeratorsResponseFetcher();
    }

    public Iterator<ListChannelModeratorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListChannelModeratorsResponseFetcher
    implements SyncPageFetcher<ListChannelModeratorsResponse> {
        private ListChannelModeratorsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelModeratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelModeratorsResponse nextPage(ListChannelModeratorsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelModeratorsIterable.this.client.listChannelModerators(ListChannelModeratorsIterable.this.firstRequest);
            }
            return ListChannelModeratorsIterable.this.client.listChannelModerators((ListChannelModeratorsRequest)((Object)ListChannelModeratorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

