/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkidentity.model.AllowMessages;
import software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceUserEndpointType;
import software.amazon.awssdk.services.chimesdkidentity.model.EndpointAttributes;
import software.amazon.awssdk.services.chimesdkidentity.model.EndpointState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppInstanceUserEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppInstanceUserEndpoint> {
    private static final SdkField<String> APP_INSTANCE_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceUserArn").getter(AppInstanceUserEndpoint.getter(AppInstanceUserEndpoint::appInstanceUserArn)).setter(AppInstanceUserEndpoint.setter(Builder::appInstanceUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceUserArn").build()}).build();
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(AppInstanceUserEndpoint.getter(AppInstanceUserEndpoint::endpointId)).setter(AppInstanceUserEndpoint.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AppInstanceUserEndpoint.getter(AppInstanceUserEndpoint::name)).setter(AppInstanceUserEndpoint.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AppInstanceUserEndpoint.getter(AppInstanceUserEndpoint::typeAsString)).setter(AppInstanceUserEndpoint.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(AppInstanceUserEndpoint.getter(AppInstanceUserEndpoint::resourceArn)).setter(AppInstanceUserEndpoint.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<EndpointAttributes> ENDPOINT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointAttributes").getter(AppInstanceUserEndpoint.getter(AppInstanceUserEndpoint::endpointAttributes)).setter(AppInstanceUserEndpoint.setter(Builder::endpointAttributes)).constructor(EndpointAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointAttributes").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(AppInstanceUserEndpoint.getter(AppInstanceUserEndpoint::createdTimestamp)).setter(AppInstanceUserEndpoint.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTimestamp").getter(AppInstanceUserEndpoint.getter(AppInstanceUserEndpoint::lastUpdatedTimestamp)).setter(AppInstanceUserEndpoint.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<String> ALLOW_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllowMessages").getter(AppInstanceUserEndpoint.getter(AppInstanceUserEndpoint::allowMessagesAsString)).setter(AppInstanceUserEndpoint.setter(Builder::allowMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMessages").build()}).build();
    private static final SdkField<EndpointState> ENDPOINT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointState").getter(AppInstanceUserEndpoint.getter(AppInstanceUserEndpoint::endpointState)).setter(AppInstanceUserEndpoint.setter(Builder::endpointState)).constructor(EndpointState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_USER_ARN_FIELD, ENDPOINT_ID_FIELD, NAME_FIELD, TYPE_FIELD, RESOURCE_ARN_FIELD, ENDPOINT_ATTRIBUTES_FIELD, CREATED_TIMESTAMP_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, ALLOW_MESSAGES_FIELD, ENDPOINT_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppInstanceUserEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appInstanceUserArn;
    private final String endpointId;
    private final String name;
    private final String type;
    private final String resourceArn;
    private final EndpointAttributes endpointAttributes;
    private final Instant createdTimestamp;
    private final Instant lastUpdatedTimestamp;
    private final String allowMessages;
    private final EndpointState endpointState;

    private AppInstanceUserEndpoint(BuilderImpl builder) {
        this.appInstanceUserArn = builder.appInstanceUserArn;
        this.endpointId = builder.endpointId;
        this.name = builder.name;
        this.type = builder.type;
        this.resourceArn = builder.resourceArn;
        this.endpointAttributes = builder.endpointAttributes;
        this.createdTimestamp = builder.createdTimestamp;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.allowMessages = builder.allowMessages;
        this.endpointState = builder.endpointState;
    }

    public final String appInstanceUserArn() {
        return this.appInstanceUserArn;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final String name() {
        return this.name;
    }

    public final AppInstanceUserEndpointType type() {
        return AppInstanceUserEndpointType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final EndpointAttributes endpointAttributes() {
        return this.endpointAttributes;
    }

    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    public final Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final AllowMessages allowMessages() {
        return AllowMessages.fromValue(this.allowMessages);
    }

    public final String allowMessagesAsString() {
        return this.allowMessages;
    }

    public final EndpointState endpointState() {
        return this.endpointState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowMessagesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceUserEndpoint)) {
            return false;
        }
        AppInstanceUserEndpoint other = (AppInstanceUserEndpoint)obj;
        return Objects.equals(this.appInstanceUserArn(), other.appInstanceUserArn()) && Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.endpointAttributes(), other.endpointAttributes()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.allowMessagesAsString(), other.allowMessagesAsString()) && Objects.equals(this.endpointState(), other.endpointState());
    }

    public final String toString() {
        return ToString.builder((String)"AppInstanceUserEndpoint").add("AppInstanceUserArn", (Object)this.appInstanceUserArn()).add("EndpointId", (Object)this.endpointId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).add("ResourceArn", (Object)this.resourceArn()).add("EndpointAttributes", (Object)this.endpointAttributes()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("AllowMessages", (Object)this.allowMessagesAsString()).add("EndpointState", (Object)this.endpointState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceUserArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceUserArn()));
            }
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "EndpointAttributes": {
                return Optional.ofNullable(clazz.cast(this.endpointAttributes()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "AllowMessages": {
                return Optional.ofNullable(clazz.cast(this.allowMessagesAsString()));
            }
            case "EndpointState": {
                return Optional.ofNullable(clazz.cast(this.endpointState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppInstanceUserArn", APP_INSTANCE_USER_ARN_FIELD);
        map.put("EndpointId", ENDPOINT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("EndpointAttributes", ENDPOINT_ATTRIBUTES_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("AllowMessages", ALLOW_MESSAGES_FIELD);
        map.put("EndpointState", ENDPOINT_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceUserEndpoint, T> g) {
        return obj -> g.apply((AppInstanceUserEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appInstanceUserArn;
        private String endpointId;
        private String name;
        private String type;
        private String resourceArn;
        private EndpointAttributes endpointAttributes;
        private Instant createdTimestamp;
        private Instant lastUpdatedTimestamp;
        private String allowMessages;
        private EndpointState endpointState;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceUserEndpoint model) {
            this.appInstanceUserArn(model.appInstanceUserArn);
            this.endpointId(model.endpointId);
            this.name(model.name);
            this.type(model.type);
            this.resourceArn(model.resourceArn);
            this.endpointAttributes(model.endpointAttributes);
            this.createdTimestamp(model.createdTimestamp);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.allowMessages(model.allowMessages);
            this.endpointState(model.endpointState);
        }

        public final String getAppInstanceUserArn() {
            return this.appInstanceUserArn;
        }

        public final void setAppInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
        }

        @Override
        public final Builder appInstanceUserArn(String appInstanceUserArn) {
            this.appInstanceUserArn = appInstanceUserArn;
            return this;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppInstanceUserEndpointType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final EndpointAttributes.Builder getEndpointAttributes() {
            return this.endpointAttributes != null ? this.endpointAttributes.toBuilder() : null;
        }

        public final void setEndpointAttributes(EndpointAttributes.BuilderImpl endpointAttributes) {
            this.endpointAttributes = endpointAttributes != null ? endpointAttributes.build() : null;
        }

        @Override
        public final Builder endpointAttributes(EndpointAttributes endpointAttributes) {
            this.endpointAttributes = endpointAttributes;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final String getAllowMessages() {
            return this.allowMessages;
        }

        public final void setAllowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
        }

        @Override
        public final Builder allowMessages(String allowMessages) {
            this.allowMessages = allowMessages;
            return this;
        }

        @Override
        public final Builder allowMessages(AllowMessages allowMessages) {
            this.allowMessages(allowMessages == null ? null : allowMessages.toString());
            return this;
        }

        public final EndpointState.Builder getEndpointState() {
            return this.endpointState != null ? this.endpointState.toBuilder() : null;
        }

        public final void setEndpointState(EndpointState.BuilderImpl endpointState) {
            this.endpointState = endpointState != null ? endpointState.build() : null;
        }

        @Override
        public final Builder endpointState(EndpointState endpointState) {
            this.endpointState = endpointState;
            return this;
        }

        public AppInstanceUserEndpoint build() {
            return new AppInstanceUserEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppInstanceUserEndpoint> {
        public Builder appInstanceUserArn(String var1);

        public Builder endpointId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(AppInstanceUserEndpointType var1);

        public Builder resourceArn(String var1);

        public Builder endpointAttributes(EndpointAttributes var1);

        default public Builder endpointAttributes(Consumer<EndpointAttributes.Builder> endpointAttributes) {
            return this.endpointAttributes((EndpointAttributes)((EndpointAttributes.Builder)EndpointAttributes.builder().applyMutation(endpointAttributes)).build());
        }

        public Builder createdTimestamp(Instant var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder allowMessages(String var1);

        public Builder allowMessages(AllowMessages var1);

        public Builder endpointState(EndpointState var1);

        default public Builder endpointState(Consumer<EndpointState.Builder> endpointState) {
            return this.endpointState((EndpointState)((EndpointState.Builder)EndpointState.builder().applyMutation(endpointState)).build());
        }
    }
}

