/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointAttributes> {
    private static final SdkField<String> DEVICE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceToken").getter(EndpointAttributes.getter(EndpointAttributes::deviceToken)).setter(EndpointAttributes.setter(Builder::deviceToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceToken").build()}).build();
    private static final SdkField<String> VOIP_DEVICE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoipDeviceToken").getter(EndpointAttributes.getter(EndpointAttributes::voipDeviceToken)).setter(EndpointAttributes.setter(Builder::voipDeviceToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoipDeviceToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_TOKEN_FIELD, VOIP_DEVICE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EndpointAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String deviceToken;
    private final String voipDeviceToken;

    private EndpointAttributes(BuilderImpl builder) {
        this.deviceToken = builder.deviceToken;
        this.voipDeviceToken = builder.voipDeviceToken;
    }

    public final String deviceToken() {
        return this.deviceToken;
    }

    public final String voipDeviceToken() {
        return this.voipDeviceToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.voipDeviceToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointAttributes)) {
            return false;
        }
        EndpointAttributes other = (EndpointAttributes)obj;
        return Objects.equals(this.deviceToken(), other.deviceToken()) && Objects.equals(this.voipDeviceToken(), other.voipDeviceToken());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointAttributes").add("DeviceToken", (Object)(this.deviceToken() == null ? null : "*** Sensitive Data Redacted ***")).add("VoipDeviceToken", (Object)(this.voipDeviceToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceToken": {
                return Optional.ofNullable(clazz.cast(this.deviceToken()));
            }
            case "VoipDeviceToken": {
                return Optional.ofNullable(clazz.cast(this.voipDeviceToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DeviceToken", DEVICE_TOKEN_FIELD);
        map.put("VoipDeviceToken", VOIP_DEVICE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointAttributes, T> g) {
        return obj -> g.apply((EndpointAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceToken;
        private String voipDeviceToken;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointAttributes model) {
            this.deviceToken(model.deviceToken);
            this.voipDeviceToken(model.voipDeviceToken);
        }

        public final String getDeviceToken() {
            return this.deviceToken;
        }

        public final void setDeviceToken(String deviceToken) {
            this.deviceToken = deviceToken;
        }

        @Override
        public final Builder deviceToken(String deviceToken) {
            this.deviceToken = deviceToken;
            return this;
        }

        public final String getVoipDeviceToken() {
            return this.voipDeviceToken;
        }

        public final void setVoipDeviceToken(String voipDeviceToken) {
            this.voipDeviceToken = voipDeviceToken;
        }

        @Override
        public final Builder voipDeviceToken(String voipDeviceToken) {
            this.voipDeviceToken = voipDeviceToken;
            return this;
        }

        public EndpointAttributes build() {
            return new EndpointAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointAttributes> {
        public Builder deviceToken(String var1);

        public Builder voipDeviceToken(String var1);
    }
}

