/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorCode {
    BAD_REQUEST("BadRequest"),
    CONFLICT("Conflict"),
    FORBIDDEN("Forbidden"),
    NOT_FOUND("NotFound"),
    PRECONDITION_FAILED("PreconditionFailed"),
    RESOURCE_LIMIT_EXCEEDED("ResourceLimitExceeded"),
    SERVICE_FAILURE("ServiceFailure"),
    ACCESS_DENIED("AccessDenied"),
    SERVICE_UNAVAILABLE("ServiceUnavailable"),
    THROTTLED("Throttled"),
    THROTTLING("Throttling"),
    UNAUTHORIZED("Unauthorized"),
    UNPROCESSABLE("Unprocessable"),
    VOICE_CONNECTOR_GROUP_ASSOCIATIONS_EXIST("VoiceConnectorGroupAssociationsExist"),
    PHONE_NUMBER_ASSOCIATIONS_EXIST("PhoneNumberAssociationsExist"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCode> VALUE_MAP;
    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        EnumSet<ErrorCode> knownValues = EnumSet.allOf(ErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorCode.class, ErrorCode::toString);
    }
}

