/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceUserListCopier;
import software.amazon.awssdk.services.chimesdkidentity.model.AppInstanceUserSummary;
import software.amazon.awssdk.services.chimesdkidentity.model.ChimeSdkIdentityResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppInstanceUsersResponse
extends ChimeSdkIdentityResponse
implements ToCopyableBuilder<Builder, ListAppInstanceUsersResponse> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceArn").getter(ListAppInstanceUsersResponse.getter(ListAppInstanceUsersResponse::appInstanceArn)).setter(ListAppInstanceUsersResponse.setter(Builder::appInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()}).build();
    private static final SdkField<List<AppInstanceUserSummary>> APP_INSTANCE_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppInstanceUsers").getter(ListAppInstanceUsersResponse.getter(ListAppInstanceUsersResponse::appInstanceUsers)).setter(ListAppInstanceUsersResponse.setter(Builder::appInstanceUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceUsers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppInstanceUserSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAppInstanceUsersResponse.getter(ListAppInstanceUsersResponse::nextToken)).setter(ListAppInstanceUsersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD, APP_INSTANCE_USERS_FIELD, NEXT_TOKEN_FIELD));
    private final String appInstanceArn;
    private final List<AppInstanceUserSummary> appInstanceUsers;
    private final String nextToken;

    private ListAppInstanceUsersResponse(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.appInstanceUsers = builder.appInstanceUsers;
        this.nextToken = builder.nextToken;
    }

    public final String appInstanceArn() {
        return this.appInstanceArn;
    }

    public final boolean hasAppInstanceUsers() {
        return this.appInstanceUsers != null && !(this.appInstanceUsers instanceof SdkAutoConstructList);
    }

    public final List<AppInstanceUserSummary> appInstanceUsers() {
        return this.appInstanceUsers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppInstanceUsers() ? this.appInstanceUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppInstanceUsersResponse)) {
            return false;
        }
        ListAppInstanceUsersResponse other = (ListAppInstanceUsersResponse)((Object)obj);
        return Objects.equals(this.appInstanceArn(), other.appInstanceArn()) && this.hasAppInstanceUsers() == other.hasAppInstanceUsers() && Objects.equals(this.appInstanceUsers(), other.appInstanceUsers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppInstanceUsersResponse").add("AppInstanceArn", (Object)this.appInstanceArn()).add("AppInstanceUsers", this.hasAppInstanceUsers() ? this.appInstanceUsers() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceArn()));
            }
            case "AppInstanceUsers": {
                return Optional.ofNullable(clazz.cast(this.appInstanceUsers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppInstanceUsersResponse, T> g) {
        return obj -> g.apply((ListAppInstanceUsersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkIdentityResponse.BuilderImpl
    implements Builder {
        private String appInstanceArn;
        private List<AppInstanceUserSummary> appInstanceUsers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppInstanceUsersResponse model) {
            super(model);
            this.appInstanceArn(model.appInstanceArn);
            this.appInstanceUsers(model.appInstanceUsers);
            this.nextToken(model.nextToken);
        }

        public final String getAppInstanceArn() {
            return this.appInstanceArn;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final List<AppInstanceUserSummary.Builder> getAppInstanceUsers() {
            List<AppInstanceUserSummary.Builder> result = AppInstanceUserListCopier.copyToBuilder(this.appInstanceUsers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppInstanceUsers(Collection<AppInstanceUserSummary.BuilderImpl> appInstanceUsers) {
            this.appInstanceUsers = AppInstanceUserListCopier.copyFromBuilder(appInstanceUsers);
        }

        @Override
        public final Builder appInstanceUsers(Collection<AppInstanceUserSummary> appInstanceUsers) {
            this.appInstanceUsers = AppInstanceUserListCopier.copy(appInstanceUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceUsers(AppInstanceUserSummary ... appInstanceUsers) {
            this.appInstanceUsers(Arrays.asList(appInstanceUsers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appInstanceUsers(Consumer<AppInstanceUserSummary.Builder> ... appInstanceUsers) {
            this.appInstanceUsers(Stream.of(appInstanceUsers).map(c -> (AppInstanceUserSummary)((AppInstanceUserSummary.Builder)AppInstanceUserSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppInstanceUsersResponse build() {
            return new ListAppInstanceUsersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkIdentityResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppInstanceUsersResponse> {
        public Builder appInstanceArn(String var1);

        public Builder appInstanceUsers(Collection<AppInstanceUserSummary> var1);

        public Builder appInstanceUsers(AppInstanceUserSummary ... var1);

        public Builder appInstanceUsers(Consumer<AppInstanceUserSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

