/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkidentity;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.chimesdkidentity.ChimeSdkIdentityAsyncClient;
import software.amazon.awssdk.services.chimesdkidentity.ChimeSdkIdentityAsyncClientBuilder;
import software.amazon.awssdk.services.chimesdkidentity.ChimeSdkIdentityServiceClientConfiguration;
import software.amazon.awssdk.services.chimesdkidentity.DefaultChimeSdkIdentityAsyncClient;
import software.amazon.awssdk.services.chimesdkidentity.DefaultChimeSdkIdentityBaseClientBuilder;
import software.amazon.awssdk.services.chimesdkidentity.endpoints.ChimeSdkIdentityEndpointProvider;

@SdkInternalApi
final class DefaultChimeSdkIdentityAsyncClientBuilder
extends DefaultChimeSdkIdentityBaseClientBuilder<ChimeSdkIdentityAsyncClientBuilder, ChimeSdkIdentityAsyncClient>
implements ChimeSdkIdentityAsyncClientBuilder {
    DefaultChimeSdkIdentityAsyncClientBuilder() {
    }

    @Override
    public DefaultChimeSdkIdentityAsyncClientBuilder endpointProvider(ChimeSdkIdentityEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ChimeSdkIdentityAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultChimeSdkIdentityAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ChimeSdkIdentityServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultChimeSdkIdentityAsyncClient client = new DefaultChimeSdkIdentityAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ChimeSdkIdentityServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ChimeSdkIdentityServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

