/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.OriginationRouteProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginationRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginationRoute> {
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OriginationRoute.getter(OriginationRoute::host)).setter(OriginationRoute.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OriginationRoute.getter(OriginationRoute::port)).setter(OriginationRoute.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OriginationRoute.getter(OriginationRoute::protocolAsString)).setter(OriginationRoute.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OriginationRoute.getter(OriginationRoute::priority)).setter(OriginationRoute.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OriginationRoute.getter(OriginationRoute::weight)).setter(OriginationRoute.setter(Builder::weight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD, PROTOCOL_FIELD, PRIORITY_FIELD, WEIGHT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String host;
    private final Integer port;
    private final String protocol;
    private final Integer priority;
    private final Integer weight;

    private OriginationRoute(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.priority = builder.priority;
        this.weight = builder.weight;
    }

    public String host() {
        return this.host;
    }

    public Integer port() {
        return this.port;
    }

    public OriginationRouteProtocol protocol() {
        return OriginationRouteProtocol.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Integer priority() {
        return this.priority;
    }

    public Integer weight() {
        return this.weight;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.weight());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginationRoute)) {
            return false;
        }
        OriginationRoute other = (OriginationRoute)obj;
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.weight(), other.weight());
    }

    public String toString() {
        return ToString.builder((String)"OriginationRoute").add("Host", (Object)this.host()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).add("Priority", (Object)this.priority()).add("Weight", (Object)this.weight()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Weight": {
                return Optional.ofNullable(clazz.cast(this.weight()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginationRoute, T> g) {
        return obj -> g.apply((OriginationRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String host;
        private Integer port;
        private String protocol;
        private Integer priority;
        private Integer weight;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginationRoute model) {
            this.host(model.host);
            this.port(model.port);
            this.protocol(model.protocol);
            this.priority(model.priority);
            this.weight(model.weight);
        }

        public final String getHost() {
            return this.host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getProtocolAsString() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(OriginationRouteProtocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final Integer getWeight() {
            return this.weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        public OriginationRoute build() {
            return new OriginationRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginationRoute> {
        public Builder host(String var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(OriginationRouteProtocol var1);

        public Builder priority(Integer var1);

        public Builder weight(Integer var1);
    }
}

