/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ErrorCode {
    UNAUTHORIZED("Unauthorized"),
    FORBIDDEN("Forbidden"),
    NOT_FOUND("NotFound"),
    BAD_REQUEST("BadRequest"),
    CONFLICT("Conflict"),
    SERVICE_FAILURE("ServiceFailure"),
    SERVICE_UNAVAILABLE("ServiceUnavailable"),
    UNPROCESSABLE("Unprocessable"),
    THROTTLED("Throttled"),
    PRECONDITION_FAILED("PreconditionFailed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCode> knownValues() {
        return Stream.of(ErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

