/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchAvailablePhoneNumbersResponse extends ChimeResponse implements
        ToCopyableBuilder<SearchAvailablePhoneNumbersResponse.Builder, SearchAvailablePhoneNumbersResponse> {
    private static final SdkField<List<String>> E164_PHONE_NUMBERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("E164PhoneNumbers")
            .getter(getter(SearchAvailablePhoneNumbersResponse::e164PhoneNumbers))
            .setter(setter(Builder::e164PhoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("E164PhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchAvailablePhoneNumbersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E164_PHONE_NUMBERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> e164PhoneNumbers;

    private final String nextToken;

    private SearchAvailablePhoneNumbersResponse(BuilderImpl builder) {
        super(builder);
        this.e164PhoneNumbers = builder.e164PhoneNumbers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the E164PhoneNumbers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasE164PhoneNumbers() {
        return e164PhoneNumbers != null && !(e164PhoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of phone numbers, in E.164 format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasE164PhoneNumbers} method.
     * </p>
     * 
     * @return List of phone numbers, in E.164 format.
     */
    public final List<String> e164PhoneNumbers() {
        return e164PhoneNumbers;
    }

    /**
     * <p>
     * The token used to retrieve the next page of search results.
     * </p>
     * 
     * @return The token used to retrieve the next page of search results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasE164PhoneNumbers() ? e164PhoneNumbers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAvailablePhoneNumbersResponse)) {
            return false;
        }
        SearchAvailablePhoneNumbersResponse other = (SearchAvailablePhoneNumbersResponse) obj;
        return hasE164PhoneNumbers() == other.hasE164PhoneNumbers()
                && Objects.equals(e164PhoneNumbers(), other.e164PhoneNumbers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchAvailablePhoneNumbersResponse")
                .add("E164PhoneNumbers", e164PhoneNumbers() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "E164PhoneNumbers":
            return Optional.ofNullable(clazz.cast(e164PhoneNumbers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("E164PhoneNumbers", E164_PHONE_NUMBERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchAvailablePhoneNumbersResponse, T> g) {
        return obj -> g.apply((SearchAvailablePhoneNumbersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchAvailablePhoneNumbersResponse> {
        /**
         * <p>
         * List of phone numbers, in E.164 format.
         * </p>
         * 
         * @param e164PhoneNumbers
         *        List of phone numbers, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers);

        /**
         * <p>
         * List of phone numbers, in E.164 format.
         * </p>
         * 
         * @param e164PhoneNumbers
         *        List of phone numbers, in E.164 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder e164PhoneNumbers(String... e164PhoneNumbers);

        /**
         * <p>
         * The token used to retrieve the next page of search results.
         * </p>
         * 
         * @param nextToken
         *        The token used to retrieve the next page of search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<String> e164PhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAvailablePhoneNumbersResponse model) {
            super(model);
            e164PhoneNumbers(model.e164PhoneNumbers);
            nextToken(model.nextToken);
        }

        public final Collection<String> getE164PhoneNumbers() {
            if (e164PhoneNumbers instanceof SdkAutoConstructList) {
                return null;
            }
            return e164PhoneNumbers;
        }

        public final void setE164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
        }

        @Override
        public final Builder e164PhoneNumbers(Collection<String> e164PhoneNumbers) {
            this.e164PhoneNumbers = E164PhoneNumberListCopier.copy(e164PhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder e164PhoneNumbers(String... e164PhoneNumbers) {
            e164PhoneNumbers(Arrays.asList(e164PhoneNumbers));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchAvailablePhoneNumbersResponse build() {
            return new SearchAvailablePhoneNumbersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
