/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The room membership details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoomMembership implements SdkPojo, Serializable, ToCopyableBuilder<RoomMembership.Builder, RoomMembership> {
    private static final SdkField<String> ROOM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RoomId")
            .getter(getter(RoomMembership::roomId)).setter(setter(Builder::roomId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomId").build()).build();

    private static final SdkField<Member> MEMBER_FIELD = SdkField.<Member> builder(MarshallingType.SDK_POJO).memberName("Member")
            .getter(getter(RoomMembership::member)).setter(setter(Builder::member)).constructor(Member::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Member").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(RoomMembership::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> INVITED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvitedBy").getter(getter(RoomMembership::invitedBy)).setter(setter(Builder::invitedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedBy").build()).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedTimestamp")
            .getter(getter(RoomMembership::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ID_FIELD, MEMBER_FIELD,
            ROLE_FIELD, INVITED_BY_FIELD, UPDATED_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roomId;

    private final Member member;

    private final String role;

    private final String invitedBy;

    private final Instant updatedTimestamp;

    private RoomMembership(BuilderImpl builder) {
        this.roomId = builder.roomId;
        this.member = builder.member;
        this.role = builder.role;
        this.invitedBy = builder.invitedBy;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The room ID.
     * </p>
     * 
     * @return The room ID.
     */
    public final String roomId() {
        return roomId;
    }

    /**
     * <p>
     * The member details, such as email address, name, member ID, and member type.
     * </p>
     * 
     * @return The member details, such as email address, name, member ID, and member type.
     */
    public final Member member() {
        return member;
    }

    /**
     * <p>
     * The membership role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link RoomMembershipRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The membership role.
     * @see RoomMembershipRole
     */
    public final RoomMembershipRole role() {
        return RoomMembershipRole.fromValue(role);
    }

    /**
     * <p>
     * The membership role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link RoomMembershipRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The membership role.
     * @see RoomMembershipRole
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * The identifier of the user that invited the room member.
     * </p>
     * 
     * @return The identifier of the user that invited the room member.
     */
    public final String invitedBy() {
        return invitedBy;
    }

    /**
     * <p>
     * The room membership update timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The room membership update timestamp, in ISO 8601 format.
     */
    public final Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomId());
        hashCode = 31 * hashCode + Objects.hashCode(member());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(invitedBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoomMembership)) {
            return false;
        }
        RoomMembership other = (RoomMembership) obj;
        return Objects.equals(roomId(), other.roomId()) && Objects.equals(member(), other.member())
                && Objects.equals(roleAsString(), other.roleAsString()) && Objects.equals(invitedBy(), other.invitedBy())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoomMembership").add("RoomId", roomId()).add("Member", member()).add("Role", roleAsString())
                .add("InvitedBy", invitedBy()).add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomId":
            return Optional.ofNullable(clazz.cast(roomId()));
        case "Member":
            return Optional.ofNullable(clazz.cast(member()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "InvitedBy":
            return Optional.ofNullable(clazz.cast(invitedBy()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RoomId", ROOM_ID_FIELD);
        map.put("Member", MEMBER_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("InvitedBy", INVITED_BY_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoomMembership, T> g) {
        return obj -> g.apply((RoomMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoomMembership> {
        /**
         * <p>
         * The room ID.
         * </p>
         * 
         * @param roomId
         *        The room ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomId(String roomId);

        /**
         * <p>
         * The member details, such as email address, name, member ID, and member type.
         * </p>
         * 
         * @param member
         *        The member details, such as email address, name, member ID, and member type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder member(Member member);

        /**
         * <p>
         * The member details, such as email address, name, member ID, and member type.
         * </p>
         * This is a convenience method that creates an instance of the {@link Member.Builder} avoiding the need to
         * create one manually via {@link Member#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Member.Builder#build()} is called immediately and its result is
         * passed to {@link #member(Member)}.
         * 
         * @param member
         *        a consumer that will call methods on {@link Member.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #member(Member)
         */
        default Builder member(Consumer<Member.Builder> member) {
            return member(Member.builder().applyMutation(member).build());
        }

        /**
         * <p>
         * The membership role.
         * </p>
         * 
         * @param role
         *        The membership role.
         * @see RoomMembershipRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoomMembershipRole
         */
        Builder role(String role);

        /**
         * <p>
         * The membership role.
         * </p>
         * 
         * @param role
         *        The membership role.
         * @see RoomMembershipRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoomMembershipRole
         */
        Builder role(RoomMembershipRole role);

        /**
         * <p>
         * The identifier of the user that invited the room member.
         * </p>
         * 
         * @param invitedBy
         *        The identifier of the user that invited the room member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitedBy(String invitedBy);

        /**
         * <p>
         * The room membership update timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The room membership update timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String roomId;

        private Member member;

        private String role;

        private String invitedBy;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RoomMembership model) {
            roomId(model.roomId);
            member(model.member);
            role(model.role);
            invitedBy(model.invitedBy);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getRoomId() {
            return roomId;
        }

        public final void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        @Override
        public final Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public final Member.Builder getMember() {
            return member != null ? member.toBuilder() : null;
        }

        public final void setMember(Member.BuilderImpl member) {
            this.member = member != null ? member.build() : null;
        }

        @Override
        public final Builder member(Member member) {
            this.member = member;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoomMembershipRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getInvitedBy() {
            return invitedBy;
        }

        public final void setInvitedBy(String invitedBy) {
            this.invitedBy = invitedBy;
        }

        @Override
        public final Builder invitedBy(String invitedBy) {
            this.invitedBy = invitedBy;
            return this;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        @Override
        public RoomMembership build() {
            return new RoomMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
