/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.SigninDelegateGroup;
import software.amazon.awssdk.services.chime.model.SigninDelegateGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSigninDelegateGroupsWithAccountRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, AssociateSigninDelegateGroupsWithAccountRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AssociateSigninDelegateGroupsWithAccountRequest.getter(AssociateSigninDelegateGroupsWithAccountRequest::accountId)).setter(AssociateSigninDelegateGroupsWithAccountRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<List<SigninDelegateGroup>> SIGNIN_DELEGATE_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SigninDelegateGroups").getter(AssociateSigninDelegateGroupsWithAccountRequest.getter(AssociateSigninDelegateGroupsWithAccountRequest::signinDelegateGroups)).setter(AssociateSigninDelegateGroupsWithAccountRequest.setter(Builder::signinDelegateGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigninDelegateGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SigninDelegateGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, SIGNIN_DELEGATE_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateSigninDelegateGroupsWithAccountRequest.memberNameToFieldInitializer();
    private final String accountId;
    private final List<SigninDelegateGroup> signinDelegateGroups;

    private AssociateSigninDelegateGroupsWithAccountRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.signinDelegateGroups = builder.signinDelegateGroups;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasSigninDelegateGroups() {
        return this.signinDelegateGroups != null && !(this.signinDelegateGroups instanceof SdkAutoConstructList);
    }

    public final List<SigninDelegateGroup> signinDelegateGroups() {
        return this.signinDelegateGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSigninDelegateGroups() ? this.signinDelegateGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSigninDelegateGroupsWithAccountRequest)) {
            return false;
        }
        AssociateSigninDelegateGroupsWithAccountRequest other = (AssociateSigninDelegateGroupsWithAccountRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && this.hasSigninDelegateGroups() == other.hasSigninDelegateGroups() && Objects.equals(this.signinDelegateGroups(), other.signinDelegateGroups());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateSigninDelegateGroupsWithAccountRequest").add("AccountId", (Object)this.accountId()).add("SigninDelegateGroups", this.hasSigninDelegateGroups() ? this.signinDelegateGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "SigninDelegateGroups": {
                return Optional.ofNullable(clazz.cast(this.signinDelegateGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("SigninDelegateGroups", SIGNIN_DELEGATE_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateSigninDelegateGroupsWithAccountRequest, T> g) {
        return obj -> g.apply((AssociateSigninDelegateGroupsWithAccountRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private List<SigninDelegateGroup> signinDelegateGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSigninDelegateGroupsWithAccountRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.signinDelegateGroups(model.signinDelegateGroups);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final List<SigninDelegateGroup.Builder> getSigninDelegateGroups() {
            List<SigninDelegateGroup.Builder> result = SigninDelegateGroupListCopier.copyToBuilder(this.signinDelegateGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSigninDelegateGroups(Collection<SigninDelegateGroup.BuilderImpl> signinDelegateGroups) {
            this.signinDelegateGroups = SigninDelegateGroupListCopier.copyFromBuilder(signinDelegateGroups);
        }

        @Override
        public final Builder signinDelegateGroups(Collection<SigninDelegateGroup> signinDelegateGroups) {
            this.signinDelegateGroups = SigninDelegateGroupListCopier.copy(signinDelegateGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signinDelegateGroups(SigninDelegateGroup ... signinDelegateGroups) {
            this.signinDelegateGroups(Arrays.asList(signinDelegateGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signinDelegateGroups(Consumer<SigninDelegateGroup.Builder> ... signinDelegateGroups) {
            this.signinDelegateGroups(Stream.of(signinDelegateGroups).map(c -> (SigninDelegateGroup)((SigninDelegateGroup.Builder)SigninDelegateGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSigninDelegateGroupsWithAccountRequest build() {
            return new AssociateSigninDelegateGroupsWithAccountRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSigninDelegateGroupsWithAccountRequest> {
        public Builder accountId(String var1);

        public Builder signinDelegateGroups(Collection<SigninDelegateGroup> var1);

        public Builder signinDelegateGroups(SigninDelegateGroup ... var1);

        public Builder signinDelegateGroups(Consumer<SigninDelegateGroup.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

