/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.InviteStatus;
import software.amazon.awssdk.services.chime.model.License;
import software.amazon.awssdk.services.chime.model.RegistrationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, User> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::userId)).setter(User.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::accountId)).setter(User.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> PRIMARY_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::primaryEmail)).setter(User.setter(Builder::primaryEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryEmail").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::displayName)).setter(User.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::licenseTypeAsString)).setter(User.setter(Builder::licenseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()}).build();
    private static final SdkField<String> USER_REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::userRegistrationStatusAsString)).setter(User.setter(Builder::userRegistrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRegistrationStatus").build()}).build();
    private static final SdkField<String> USER_INVITATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::userInvitationStatusAsString)).setter(User.setter(Builder::userInvitationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInvitationStatus").build()}).build();
    private static final SdkField<Instant> REGISTERED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(User.getter(User::registeredOn)).setter(User.setter(Builder::registeredOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> INVITED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(User.getter(User::invitedOn)).setter(User.setter(Builder::invitedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> PERSONAL_PIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(User.getter(User::personalPIN)).setter(User.setter(Builder::personalPIN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalPIN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, ACCOUNT_ID_FIELD, PRIMARY_EMAIL_FIELD, DISPLAY_NAME_FIELD, LICENSE_TYPE_FIELD, USER_REGISTRATION_STATUS_FIELD, USER_INVITATION_STATUS_FIELD, REGISTERED_ON_FIELD, INVITED_ON_FIELD, PERSONAL_PIN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userId;
    private final String accountId;
    private final String primaryEmail;
    private final String displayName;
    private final String licenseType;
    private final String userRegistrationStatus;
    private final String userInvitationStatus;
    private final Instant registeredOn;
    private final Instant invitedOn;
    private final String personalPIN;

    private User(BuilderImpl builder) {
        this.userId = builder.userId;
        this.accountId = builder.accountId;
        this.primaryEmail = builder.primaryEmail;
        this.displayName = builder.displayName;
        this.licenseType = builder.licenseType;
        this.userRegistrationStatus = builder.userRegistrationStatus;
        this.userInvitationStatus = builder.userInvitationStatus;
        this.registeredOn = builder.registeredOn;
        this.invitedOn = builder.invitedOn;
        this.personalPIN = builder.personalPIN;
    }

    public String userId() {
        return this.userId;
    }

    public String accountId() {
        return this.accountId;
    }

    public String primaryEmail() {
        return this.primaryEmail;
    }

    public String displayName() {
        return this.displayName;
    }

    public License licenseType() {
        return License.fromValue(this.licenseType);
    }

    public String licenseTypeAsString() {
        return this.licenseType;
    }

    public RegistrationStatus userRegistrationStatus() {
        return RegistrationStatus.fromValue(this.userRegistrationStatus);
    }

    public String userRegistrationStatusAsString() {
        return this.userRegistrationStatus;
    }

    public InviteStatus userInvitationStatus() {
        return InviteStatus.fromValue(this.userInvitationStatus);
    }

    public String userInvitationStatusAsString() {
        return this.userInvitationStatus;
    }

    public Instant registeredOn() {
        return this.registeredOn;
    }

    public Instant invitedOn() {
        return this.invitedOn;
    }

    public String personalPIN() {
        return this.personalPIN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRegistrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInvitationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalPIN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.primaryEmail(), other.primaryEmail()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.licenseTypeAsString(), other.licenseTypeAsString()) && Objects.equals(this.userRegistrationStatusAsString(), other.userRegistrationStatusAsString()) && Objects.equals(this.userInvitationStatusAsString(), other.userInvitationStatusAsString()) && Objects.equals(this.registeredOn(), other.registeredOn()) && Objects.equals(this.invitedOn(), other.invitedOn()) && Objects.equals(this.personalPIN(), other.personalPIN());
    }

    public String toString() {
        return ToString.builder((String)"User").add("UserId", (Object)this.userId()).add("AccountId", (Object)this.accountId()).add("PrimaryEmail", (Object)this.primaryEmail()).add("DisplayName", (Object)this.displayName()).add("LicenseType", (Object)this.licenseTypeAsString()).add("UserRegistrationStatus", (Object)this.userRegistrationStatusAsString()).add("UserInvitationStatus", (Object)this.userInvitationStatusAsString()).add("RegisteredOn", (Object)this.registeredOn()).add("InvitedOn", (Object)this.invitedOn()).add("PersonalPIN", (Object)this.personalPIN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "PrimaryEmail": {
                return Optional.ofNullable(clazz.cast(this.primaryEmail()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseTypeAsString()));
            }
            case "UserRegistrationStatus": {
                return Optional.ofNullable(clazz.cast(this.userRegistrationStatusAsString()));
            }
            case "UserInvitationStatus": {
                return Optional.ofNullable(clazz.cast(this.userInvitationStatusAsString()));
            }
            case "RegisteredOn": {
                return Optional.ofNullable(clazz.cast(this.registeredOn()));
            }
            case "InvitedOn": {
                return Optional.ofNullable(clazz.cast(this.invitedOn()));
            }
            case "PersonalPIN": {
                return Optional.ofNullable(clazz.cast(this.personalPIN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userId;
        private String accountId;
        private String primaryEmail;
        private String displayName;
        private String licenseType;
        private String userRegistrationStatus;
        private String userInvitationStatus;
        private Instant registeredOn;
        private Instant invitedOn;
        private String personalPIN;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.userId(model.userId);
            this.accountId(model.accountId);
            this.primaryEmail(model.primaryEmail);
            this.displayName(model.displayName);
            this.licenseType(model.licenseType);
            this.userRegistrationStatus(model.userRegistrationStatus);
            this.userInvitationStatus(model.userInvitationStatus);
            this.registeredOn(model.registeredOn);
            this.invitedOn(model.invitedOn);
            this.personalPIN(model.personalPIN);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getPrimaryEmail() {
            return this.primaryEmail;
        }

        @Override
        public final Builder primaryEmail(String primaryEmail) {
            this.primaryEmail = primaryEmail;
            return this;
        }

        public final void setPrimaryEmail(String primaryEmail) {
            this.primaryEmail = primaryEmail;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getLicenseTypeAsString() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(License licenseType) {
            this.licenseType(licenseType.toString());
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getUserRegistrationStatusAsString() {
            return this.userRegistrationStatus;
        }

        @Override
        public final Builder userRegistrationStatus(String userRegistrationStatus) {
            this.userRegistrationStatus = userRegistrationStatus;
            return this;
        }

        @Override
        public final Builder userRegistrationStatus(RegistrationStatus userRegistrationStatus) {
            this.userRegistrationStatus(userRegistrationStatus.toString());
            return this;
        }

        public final void setUserRegistrationStatus(String userRegistrationStatus) {
            this.userRegistrationStatus = userRegistrationStatus;
        }

        public final String getUserInvitationStatusAsString() {
            return this.userInvitationStatus;
        }

        @Override
        public final Builder userInvitationStatus(String userInvitationStatus) {
            this.userInvitationStatus = userInvitationStatus;
            return this;
        }

        @Override
        public final Builder userInvitationStatus(InviteStatus userInvitationStatus) {
            this.userInvitationStatus(userInvitationStatus.toString());
            return this;
        }

        public final void setUserInvitationStatus(String userInvitationStatus) {
            this.userInvitationStatus = userInvitationStatus;
        }

        public final Instant getRegisteredOn() {
            return this.registeredOn;
        }

        @Override
        public final Builder registeredOn(Instant registeredOn) {
            this.registeredOn = registeredOn;
            return this;
        }

        public final void setRegisteredOn(Instant registeredOn) {
            this.registeredOn = registeredOn;
        }

        public final Instant getInvitedOn() {
            return this.invitedOn;
        }

        @Override
        public final Builder invitedOn(Instant invitedOn) {
            this.invitedOn = invitedOn;
            return this;
        }

        public final void setInvitedOn(Instant invitedOn) {
            this.invitedOn = invitedOn;
        }

        public final String getPersonalPIN() {
            return this.personalPIN;
        }

        @Override
        public final Builder personalPIN(String personalPIN) {
            this.personalPIN = personalPIN;
            return this;
        }

        public final void setPersonalPIN(String personalPIN) {
            this.personalPIN = personalPIN;
        }

        public User build() {
            return new User(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, User> {
        public Builder userId(String var1);

        public Builder accountId(String var1);

        public Builder primaryEmail(String var1);

        public Builder displayName(String var1);

        public Builder licenseType(String var1);

        public Builder licenseType(License var1);

        public Builder userRegistrationStatus(String var1);

        public Builder userRegistrationStatus(RegistrationStatus var1);

        public Builder userInvitationStatus(String var1);

        public Builder userInvitationStatus(InviteStatus var1);

        public Builder registeredOn(Instant var1);

        public Builder invitedOn(Instant var1);

        public Builder personalPIN(String var1);
    }
}

