/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.OriginationRoute;
import software.amazon.awssdk.services.chime.model.OriginationRouteListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Origination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Origination> {
    private static final SdkField<List<OriginationRoute>> ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Routes").getter(Origination.getter(Origination::routes)).setter(Origination.setter(Builder::routes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OriginationRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(Origination.getter(Origination::disabled)).setter(Origination.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTES_FIELD, DISABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Origination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<OriginationRoute> routes;
    private final Boolean disabled;

    private Origination(BuilderImpl builder) {
        this.routes = builder.routes;
        this.disabled = builder.disabled;
    }

    public final boolean hasRoutes() {
        return this.routes != null && !(this.routes instanceof SdkAutoConstructList);
    }

    public final List<OriginationRoute> routes() {
        return this.routes;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoutes() ? this.routes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Origination)) {
            return false;
        }
        Origination other = (Origination)obj;
        return this.hasRoutes() == other.hasRoutes() && Objects.equals(this.routes(), other.routes()) && Objects.equals(this.disabled(), other.disabled());
    }

    public final String toString() {
        return ToString.builder((String)"Origination").add("Routes", this.hasRoutes() ? this.routes() : null).add("Disabled", (Object)this.disabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Routes": {
                return Optional.ofNullable(clazz.cast(this.routes()));
            }
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Routes", ROUTES_FIELD);
        map.put("Disabled", DISABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Origination, T> g) {
        return obj -> g.apply((Origination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<OriginationRoute> routes = DefaultSdkAutoConstructList.getInstance();
        private Boolean disabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Origination model) {
            this.routes(model.routes);
            this.disabled(model.disabled);
        }

        public final List<OriginationRoute.Builder> getRoutes() {
            List<OriginationRoute.Builder> result = OriginationRouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<OriginationRoute.BuilderImpl> routes) {
            this.routes = OriginationRouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<OriginationRoute> routes) {
            this.routes = OriginationRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(OriginationRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<OriginationRoute.Builder> ... routes) {
            this.routes(Stream.of(routes).map(c -> (OriginationRoute)((OriginationRoute.Builder)OriginationRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public Origination build() {
            return new Origination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Origination> {
        public Builder routes(Collection<OriginationRoute> var1);

        public Builder routes(OriginationRoute ... var1);

        public Builder routes(Consumer<OriginationRoute.Builder> ... var1);

        public Builder disabled(Boolean var1);
    }
}

