/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.EmergencyCallingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutVoiceConnectorEmergencyCallingConfigurationRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, PutVoiceConnectorEmergencyCallingConfigurationRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(PutVoiceConnectorEmergencyCallingConfigurationRequest.getter(PutVoiceConnectorEmergencyCallingConfigurationRequest::voiceConnectorId)).setter(PutVoiceConnectorEmergencyCallingConfigurationRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()}).build();
    private static final SdkField<EmergencyCallingConfiguration> EMERGENCY_CALLING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EmergencyCallingConfiguration").getter(PutVoiceConnectorEmergencyCallingConfigurationRequest.getter(PutVoiceConnectorEmergencyCallingConfigurationRequest::emergencyCallingConfiguration)).setter(PutVoiceConnectorEmergencyCallingConfigurationRequest.setter(Builder::emergencyCallingConfiguration)).constructor(EmergencyCallingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmergencyCallingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, EMERGENCY_CALLING_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("voiceConnectorId", VOICE_CONNECTOR_ID_FIELD);
            this.put("EmergencyCallingConfiguration", EMERGENCY_CALLING_CONFIGURATION_FIELD);
        }
    });
    private final String voiceConnectorId;
    private final EmergencyCallingConfiguration emergencyCallingConfiguration;

    private PutVoiceConnectorEmergencyCallingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.emergencyCallingConfiguration = builder.emergencyCallingConfiguration;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final EmergencyCallingConfiguration emergencyCallingConfiguration() {
        return this.emergencyCallingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.emergencyCallingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorEmergencyCallingConfigurationRequest)) {
            return false;
        }
        PutVoiceConnectorEmergencyCallingConfigurationRequest other = (PutVoiceConnectorEmergencyCallingConfigurationRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(this.emergencyCallingConfiguration(), other.emergencyCallingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"PutVoiceConnectorEmergencyCallingConfigurationRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("EmergencyCallingConfiguration", (Object)this.emergencyCallingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "EmergencyCallingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.emergencyCallingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorEmergencyCallingConfigurationRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorEmergencyCallingConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private EmergencyCallingConfiguration emergencyCallingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorEmergencyCallingConfigurationRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.emergencyCallingConfiguration(model.emergencyCallingConfiguration);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final EmergencyCallingConfiguration.Builder getEmergencyCallingConfiguration() {
            return this.emergencyCallingConfiguration != null ? this.emergencyCallingConfiguration.toBuilder() : null;
        }

        public final void setEmergencyCallingConfiguration(EmergencyCallingConfiguration.BuilderImpl emergencyCallingConfiguration) {
            this.emergencyCallingConfiguration = emergencyCallingConfiguration != null ? emergencyCallingConfiguration.build() : null;
        }

        @Override
        public final Builder emergencyCallingConfiguration(EmergencyCallingConfiguration emergencyCallingConfiguration) {
            this.emergencyCallingConfiguration = emergencyCallingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorEmergencyCallingConfigurationRequest build() {
            return new PutVoiceConnectorEmergencyCallingConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutVoiceConnectorEmergencyCallingConfigurationRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder emergencyCallingConfiguration(EmergencyCallingConfiguration var1);

        default public Builder emergencyCallingConfiguration(Consumer<EmergencyCallingConfiguration.Builder> emergencyCallingConfiguration) {
            return this.emergencyCallingConfiguration((EmergencyCallingConfiguration)((EmergencyCallingConfiguration.Builder)EmergencyCallingConfiguration.builder().applyMutation(emergencyCallingConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

