/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.UserIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUnsuspendUserRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, BatchUnsuspendUserRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(BatchUnsuspendUserRequest.getter(BatchUnsuspendUserRequest::accountId)).setter(BatchUnsuspendUserRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("accountId").build()}).build();
    private static final SdkField<List<String>> USER_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserIdList").getter(BatchUnsuspendUserRequest.getter(BatchUnsuspendUserRequest::userIdList)).setter(BatchUnsuspendUserRequest.setter(Builder::userIdList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, USER_ID_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("accountId", ACCOUNT_ID_FIELD);
            this.put("UserIdList", USER_ID_LIST_FIELD);
        }
    });
    private final String accountId;
    private final List<String> userIdList;

    private BatchUnsuspendUserRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.userIdList = builder.userIdList;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final boolean hasUserIdList() {
        return this.userIdList != null && !(this.userIdList instanceof SdkAutoConstructList);
    }

    public final List<String> userIdList() {
        return this.userIdList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIdList() ? this.userIdList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUnsuspendUserRequest)) {
            return false;
        }
        BatchUnsuspendUserRequest other = (BatchUnsuspendUserRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && this.hasUserIdList() == other.hasUserIdList() && Objects.equals(this.userIdList(), other.userIdList());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUnsuspendUserRequest").add("AccountId", (Object)this.accountId()).add("UserIdList", this.hasUserIdList() ? this.userIdList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "UserIdList": {
                return Optional.ofNullable(clazz.cast(this.userIdList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUnsuspendUserRequest, T> g) {
        return obj -> g.apply((BatchUnsuspendUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private List<String> userIdList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUnsuspendUserRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.userIdList(model.userIdList);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Collection<String> getUserIdList() {
            if (this.userIdList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIdList;
        }

        public final void setUserIdList(Collection<String> userIdList) {
            this.userIdList = UserIdListCopier.copy(userIdList);
        }

        @Override
        public final Builder userIdList(Collection<String> userIdList) {
            this.userIdList = UserIdListCopier.copy(userIdList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdList(String ... userIdList) {
            this.userIdList(Arrays.asList(userIdList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUnsuspendUserRequest build() {
            return new BatchUnsuspendUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUnsuspendUserRequest> {
        public Builder accountId(String var1);

        public Builder userIdList(Collection<String> var1);

        public Builder userIdList(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

