/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.Address;
import software.amazon.awssdk.services.chime.model.CandidateAddress;
import software.amazon.awssdk.services.chime.model.CandidateAddressListCopier;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateE911AddressResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, ValidateE911AddressResponse> {
    private static final SdkField<Integer> VALIDATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ValidationResult").getter(ValidateE911AddressResponse.getter(ValidateE911AddressResponse::validationResult)).setter(ValidateE911AddressResponse.setter(Builder::validationResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationResult").build()}).build();
    private static final SdkField<String> ADDRESS_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressExternalId").getter(ValidateE911AddressResponse.getter(ValidateE911AddressResponse::addressExternalId)).setter(ValidateE911AddressResponse.setter(Builder::addressExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressExternalId").build()}).build();
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(ValidateE911AddressResponse.getter(ValidateE911AddressResponse::address)).setter(ValidateE911AddressResponse.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<List<CandidateAddress>> CANDIDATE_ADDRESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CandidateAddressList").getter(ValidateE911AddressResponse.getter(ValidateE911AddressResponse::candidateAddressList)).setter(ValidateE911AddressResponse.setter(Builder::candidateAddressList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CandidateAddressList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CandidateAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_RESULT_FIELD, ADDRESS_EXTERNAL_ID_FIELD, ADDRESS_FIELD, CANDIDATE_ADDRESS_LIST_FIELD));
    private final Integer validationResult;
    private final String addressExternalId;
    private final Address address;
    private final List<CandidateAddress> candidateAddressList;

    private ValidateE911AddressResponse(BuilderImpl builder) {
        super(builder);
        this.validationResult = builder.validationResult;
        this.addressExternalId = builder.addressExternalId;
        this.address = builder.address;
        this.candidateAddressList = builder.candidateAddressList;
    }

    public final Integer validationResult() {
        return this.validationResult;
    }

    public final String addressExternalId() {
        return this.addressExternalId;
    }

    public final Address address() {
        return this.address;
    }

    public final boolean hasCandidateAddressList() {
        return this.candidateAddressList != null && !(this.candidateAddressList instanceof SdkAutoConstructList);
    }

    public final List<CandidateAddress> candidateAddressList() {
        return this.candidateAddressList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.validationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.addressExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCandidateAddressList() ? this.candidateAddressList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateE911AddressResponse)) {
            return false;
        }
        ValidateE911AddressResponse other = (ValidateE911AddressResponse)((Object)obj);
        return Objects.equals(this.validationResult(), other.validationResult()) && Objects.equals(this.addressExternalId(), other.addressExternalId()) && Objects.equals(this.address(), other.address()) && this.hasCandidateAddressList() == other.hasCandidateAddressList() && Objects.equals(this.candidateAddressList(), other.candidateAddressList());
    }

    public final String toString() {
        return ToString.builder((String)"ValidateE911AddressResponse").add("ValidationResult", (Object)this.validationResult()).add("AddressExternalId", (Object)this.addressExternalId()).add("Address", (Object)this.address()).add("CandidateAddressList", this.hasCandidateAddressList() ? this.candidateAddressList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ValidationResult": {
                return Optional.ofNullable(clazz.cast(this.validationResult()));
            }
            case "AddressExternalId": {
                return Optional.ofNullable(clazz.cast(this.addressExternalId()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "CandidateAddressList": {
                return Optional.ofNullable(clazz.cast(this.candidateAddressList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateE911AddressResponse, T> g) {
        return obj -> g.apply((ValidateE911AddressResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private Integer validationResult;
        private String addressExternalId;
        private Address address;
        private List<CandidateAddress> candidateAddressList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateE911AddressResponse model) {
            super(model);
            this.validationResult(model.validationResult);
            this.addressExternalId(model.addressExternalId);
            this.address(model.address);
            this.candidateAddressList(model.candidateAddressList);
        }

        public final Integer getValidationResult() {
            return this.validationResult;
        }

        public final void setValidationResult(Integer validationResult) {
            this.validationResult = validationResult;
        }

        @Override
        public final Builder validationResult(Integer validationResult) {
            this.validationResult = validationResult;
            return this;
        }

        public final String getAddressExternalId() {
            return this.addressExternalId;
        }

        public final void setAddressExternalId(String addressExternalId) {
            this.addressExternalId = addressExternalId;
        }

        @Override
        public final Builder addressExternalId(String addressExternalId) {
            this.addressExternalId = addressExternalId;
            return this;
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final List<CandidateAddress.Builder> getCandidateAddressList() {
            List<CandidateAddress.Builder> result = CandidateAddressListCopier.copyToBuilder(this.candidateAddressList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCandidateAddressList(Collection<CandidateAddress.BuilderImpl> candidateAddressList) {
            this.candidateAddressList = CandidateAddressListCopier.copyFromBuilder(candidateAddressList);
        }

        @Override
        public final Builder candidateAddressList(Collection<CandidateAddress> candidateAddressList) {
            this.candidateAddressList = CandidateAddressListCopier.copy(candidateAddressList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateAddressList(CandidateAddress ... candidateAddressList) {
            this.candidateAddressList(Arrays.asList(candidateAddressList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder candidateAddressList(Consumer<CandidateAddress.Builder> ... candidateAddressList) {
            this.candidateAddressList(Stream.of(candidateAddressList).map(c -> (CandidateAddress)((CandidateAddress.Builder)CandidateAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ValidateE911AddressResponse build() {
            return new ValidateE911AddressResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidateE911AddressResponse> {
        public Builder validationResult(Integer var1);

        public Builder addressExternalId(String var1);

        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }

        public Builder candidateAddressList(Collection<CandidateAddress> var1);

        public Builder candidateAddressList(CandidateAddress ... var1);

        public Builder candidateAddressList(Consumer<CandidateAddress.Builder> ... var1);
    }
}

