/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.Termination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutVoiceConnectorTerminationRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, PutVoiceConnectorTerminationRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(PutVoiceConnectorTerminationRequest.getter(PutVoiceConnectorTerminationRequest::voiceConnectorId)).setter(PutVoiceConnectorTerminationRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()}).build();
    private static final SdkField<Termination> TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Termination").getter(PutVoiceConnectorTerminationRequest.getter(PutVoiceConnectorTerminationRequest::termination)).setter(PutVoiceConnectorTerminationRequest.setter(Builder::termination)).constructor(Termination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Termination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, TERMINATION_FIELD));
    private final String voiceConnectorId;
    private final Termination termination;

    private PutVoiceConnectorTerminationRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.termination = builder.termination;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final Termination termination() {
        return this.termination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.termination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorTerminationRequest)) {
            return false;
        }
        PutVoiceConnectorTerminationRequest other = (PutVoiceConnectorTerminationRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(this.termination(), other.termination());
    }

    public final String toString() {
        return ToString.builder((String)"PutVoiceConnectorTerminationRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("Termination", (Object)this.termination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "Termination": {
                return Optional.ofNullable(clazz.cast(this.termination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorTerminationRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorTerminationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private Termination termination;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorTerminationRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.termination(model.termination);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final Termination.Builder getTermination() {
            return this.termination != null ? this.termination.toBuilder() : null;
        }

        public final void setTermination(Termination.BuilderImpl termination) {
            this.termination = termination != null ? termination.build() : null;
        }

        @Override
        public final Builder termination(Termination termination) {
            this.termination = termination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorTerminationRequest build() {
            return new PutVoiceConnectorTerminationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutVoiceConnectorTerminationRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder termination(Termination var1);

        default public Builder termination(Consumer<Termination.Builder> termination) {
            return this.termination((Termination)((Termination.Builder)Termination.builder().applyMutation(termination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

