/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.ListSipRulesRequest;
import software.amazon.awssdk.services.chime.model.ListSipRulesResponse;

public class ListSipRulesIterable
implements SdkIterable<ListSipRulesResponse> {
    private final ChimeClient client;
    private final ListSipRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSipRulesIterable(ChimeClient client, ListSipRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSipRulesResponseFetcher();
    }

    public Iterator<ListSipRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSipRulesResponseFetcher
    implements SyncPageFetcher<ListSipRulesResponse> {
        private ListSipRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListSipRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSipRulesResponse nextPage(ListSipRulesResponse previousPage) {
            if (previousPage == null) {
                return ListSipRulesIterable.this.client.listSipRules(ListSipRulesIterable.this.firstRequest);
            }
            return ListSipRulesIterable.this.client.listSipRules((ListSipRulesRequest)((Object)ListSipRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

