/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.ListChannelBansRequest;
import software.amazon.awssdk.services.chime.model.ListChannelBansResponse;

public class ListChannelBansPublisher
implements SdkPublisher<ListChannelBansResponse> {
    private final ChimeAsyncClient client;
    private final ListChannelBansRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelBansPublisher(ChimeAsyncClient client, ListChannelBansRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelBansPublisher(ChimeAsyncClient client, ListChannelBansRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelBansResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelBansResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListChannelBansResponseFetcher
    implements AsyncPageFetcher<ListChannelBansResponse> {
        private ListChannelBansResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelBansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelBansResponse> nextPage(ListChannelBansResponse previousPage) {
            if (previousPage == null) {
                return ListChannelBansPublisher.this.client.listChannelBans(ListChannelBansPublisher.this.firstRequest);
            }
            return ListChannelBansPublisher.this.client.listChannelBans((ListChannelBansRequest)((Object)ListChannelBansPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

