/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.chime.ChimeClient;
import software.amazon.awssdk.services.chime.ChimeClientBuilder;
import software.amazon.awssdk.services.chime.ChimeServiceClientConfiguration;
import software.amazon.awssdk.services.chime.DefaultChimeBaseClientBuilder;
import software.amazon.awssdk.services.chime.DefaultChimeClient;
import software.amazon.awssdk.services.chime.endpoints.ChimeEndpointProvider;

@SdkInternalApi
final class DefaultChimeClientBuilder
extends DefaultChimeBaseClientBuilder<ChimeClientBuilder, ChimeClient>
implements ChimeClientBuilder {
    DefaultChimeClientBuilder() {
    }

    @Override
    public DefaultChimeClientBuilder endpointProvider(ChimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ChimeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultChimeClientBuilder.validateClientOptions(clientConfiguration);
        ChimeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultChimeClient client = new DefaultChimeClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ChimeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ChimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

