/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRoomMembershipResponse extends ChimeResponse implements
        ToCopyableBuilder<CreateRoomMembershipResponse.Builder, CreateRoomMembershipResponse> {
    private static final SdkField<RoomMembership> ROOM_MEMBERSHIP_FIELD = SdkField
            .<RoomMembership> builder(MarshallingType.SDK_POJO).memberName("RoomMembership")
            .getter(getter(CreateRoomMembershipResponse::roomMembership)).setter(setter(Builder::roomMembership))
            .constructor(RoomMembership::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomMembership").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_MEMBERSHIP_FIELD));

    private final RoomMembership roomMembership;

    private CreateRoomMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.roomMembership = builder.roomMembership;
    }

    /**
     * <p>
     * The room membership details.
     * </p>
     * 
     * @return The room membership details.
     */
    public final RoomMembership roomMembership() {
        return roomMembership;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(roomMembership());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRoomMembershipResponse)) {
            return false;
        }
        CreateRoomMembershipResponse other = (CreateRoomMembershipResponse) obj;
        return Objects.equals(roomMembership(), other.roomMembership());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRoomMembershipResponse").add("RoomMembership", roomMembership()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomMembership":
            return Optional.ofNullable(clazz.cast(roomMembership()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRoomMembershipResponse, T> g) {
        return obj -> g.apply((CreateRoomMembershipResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRoomMembershipResponse> {
        /**
         * <p>
         * The room membership details.
         * </p>
         * 
         * @param roomMembership
         *        The room membership details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomMembership(RoomMembership roomMembership);

        /**
         * <p>
         * The room membership details.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoomMembership.Builder} avoiding the need
         * to create one manually via {@link RoomMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoomMembership.Builder#build()} is called immediately and its
         * result is passed to {@link #roomMembership(RoomMembership)}.
         * 
         * @param roomMembership
         *        a consumer that will call methods on {@link RoomMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roomMembership(RoomMembership)
         */
        default Builder roomMembership(Consumer<RoomMembership.Builder> roomMembership) {
            return roomMembership(RoomMembership.builder().applyMutation(roomMembership).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private RoomMembership roomMembership;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRoomMembershipResponse model) {
            super(model);
            roomMembership(model.roomMembership);
        }

        public final RoomMembership.Builder getRoomMembership() {
            return roomMembership != null ? roomMembership.toBuilder() : null;
        }

        public final void setRoomMembership(RoomMembership.BuilderImpl roomMembership) {
            this.roomMembership = roomMembership != null ? roomMembership.build() : null;
        }

        @Override
        public final Builder roomMembership(RoomMembership roomMembership) {
            this.roomMembership = roomMembership;
            return this;
        }

        @Override
        public CreateRoomMembershipResponse build() {
            return new CreateRoomMembershipResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
