/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChimeResponse;
import software.amazon.awssdk.services.chime.model.PhoneNumberError;
import software.amazon.awssdk.services.chime.model.PhoneNumberErrorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeletePhoneNumberResponse
extends ChimeResponse
implements ToCopyableBuilder<Builder, BatchDeletePhoneNumberResponse> {
    private static final SdkField<List<PhoneNumberError>> PHONE_NUMBER_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberErrors").getter(BatchDeletePhoneNumberResponse.getter(BatchDeletePhoneNumberResponse::phoneNumberErrors)).setter(BatchDeletePhoneNumberResponse.setter(Builder::phoneNumberErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhoneNumberError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ERRORS_FIELD));
    private final List<PhoneNumberError> phoneNumberErrors;

    private BatchDeletePhoneNumberResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberErrors = builder.phoneNumberErrors;
    }

    public final boolean hasPhoneNumberErrors() {
        return this.phoneNumberErrors != null && !(this.phoneNumberErrors instanceof SdkAutoConstructList);
    }

    public final List<PhoneNumberError> phoneNumberErrors() {
        return this.phoneNumberErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberErrors() ? this.phoneNumberErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeletePhoneNumberResponse)) {
            return false;
        }
        BatchDeletePhoneNumberResponse other = (BatchDeletePhoneNumberResponse)((Object)obj);
        return this.hasPhoneNumberErrors() == other.hasPhoneNumberErrors() && Objects.equals(this.phoneNumberErrors(), other.phoneNumberErrors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeletePhoneNumberResponse").add("PhoneNumberErrors", this.hasPhoneNumberErrors() ? this.phoneNumberErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberErrors": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeletePhoneNumberResponse, T> g) {
        return obj -> g.apply((BatchDeletePhoneNumberResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeResponse.BuilderImpl
    implements Builder {
        private List<PhoneNumberError> phoneNumberErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeletePhoneNumberResponse model) {
            super(model);
            this.phoneNumberErrors(model.phoneNumberErrors);
        }

        public final List<PhoneNumberError.Builder> getPhoneNumberErrors() {
            List<PhoneNumberError.Builder> result = PhoneNumberErrorListCopier.copyToBuilder(this.phoneNumberErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder phoneNumberErrors(Collection<PhoneNumberError> phoneNumberErrors) {
            this.phoneNumberErrors = PhoneNumberErrorListCopier.copy(phoneNumberErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberErrors(PhoneNumberError ... phoneNumberErrors) {
            this.phoneNumberErrors(Arrays.asList(phoneNumberErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberErrors(Consumer<PhoneNumberError.Builder> ... phoneNumberErrors) {
            this.phoneNumberErrors(Stream.of(phoneNumberErrors).map(c -> (PhoneNumberError)((PhoneNumberError.Builder)PhoneNumberError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumberErrors(Collection<PhoneNumberError.BuilderImpl> phoneNumberErrors) {
            this.phoneNumberErrors = PhoneNumberErrorListCopier.copyFromBuilder(phoneNumberErrors);
        }

        @Override
        public BatchDeletePhoneNumberResponse build() {
            return new BatchDeletePhoneNumberResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeletePhoneNumberResponse> {
        public Builder phoneNumberErrors(Collection<PhoneNumberError> var1);

        public Builder phoneNumberErrors(PhoneNumberError ... var1);

        public Builder phoneNumberErrors(Consumer<PhoneNumberError.Builder> ... var1);
    }
}

