/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutVoiceConnectorTerminationRequest extends ChimeRequest implements
        ToCopyableBuilder<PutVoiceConnectorTerminationRequest.Builder, PutVoiceConnectorTerminationRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VoiceConnectorId").getter(getter(PutVoiceConnectorTerminationRequest::voiceConnectorId))
            .setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("voiceConnectorId").build()).build();

    private static final SdkField<Termination> TERMINATION_FIELD = SdkField.<Termination> builder(MarshallingType.SDK_POJO)
            .memberName("Termination").getter(getter(PutVoiceConnectorTerminationRequest::termination))
            .setter(setter(Builder::termination)).constructor(Termination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Termination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            TERMINATION_FIELD));

    private final String voiceConnectorId;

    private final Termination termination;

    private PutVoiceConnectorTerminationRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.termination = builder.termination;
    }

    /**
     * <p>
     * The Amazon Chime Voice Connector ID.
     * </p>
     * 
     * @return The Amazon Chime Voice Connector ID.
     */
    public final String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The termination setting details to add.
     * </p>
     * 
     * @return The termination setting details to add.
     */
    public final Termination termination() {
        return termination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(termination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutVoiceConnectorTerminationRequest)) {
            return false;
        }
        PutVoiceConnectorTerminationRequest other = (PutVoiceConnectorTerminationRequest) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(termination(), other.termination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutVoiceConnectorTerminationRequest").add("VoiceConnectorId", voiceConnectorId())
                .add("Termination", termination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "Termination":
            return Optional.ofNullable(clazz.cast(termination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutVoiceConnectorTerminationRequest, T> g) {
        return obj -> g.apply((PutVoiceConnectorTerminationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutVoiceConnectorTerminationRequest> {
        /**
         * <p>
         * The Amazon Chime Voice Connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Amazon Chime Voice Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The termination setting details to add.
         * </p>
         * 
         * @param termination
         *        The termination setting details to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termination(Termination termination);

        /**
         * <p>
         * The termination setting details to add.
         * </p>
         * This is a convenience that creates an instance of the {@link Termination.Builder} avoiding the need to create
         * one manually via {@link Termination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Termination.Builder#build()} is called immediately and its result
         * is passed to {@link #termination(Termination)}.
         * 
         * @param termination
         *        a consumer that will call methods on {@link Termination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #termination(Termination)
         */
        default Builder termination(Consumer<Termination.Builder> termination) {
            return termination(Termination.builder().applyMutation(termination).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String voiceConnectorId;

        private Termination termination;

        private BuilderImpl() {
        }

        private BuilderImpl(PutVoiceConnectorTerminationRequest model) {
            super(model);
            voiceConnectorId(model.voiceConnectorId);
            termination(model.termination);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        public final Termination.Builder getTermination() {
            return termination != null ? termination.toBuilder() : null;
        }

        @Override
        public final Builder termination(Termination termination) {
            this.termination = termination;
            return this;
        }

        public final void setTermination(Termination.BuilderImpl termination) {
            this.termination = termination != null ? termination.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutVoiceConnectorTerminationRequest build() {
            return new PutVoiceConnectorTerminationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
