/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetVoiceConnectorOriginationResponse extends ChimeResponse implements
        ToCopyableBuilder<GetVoiceConnectorOriginationResponse.Builder, GetVoiceConnectorOriginationResponse> {
    private static final SdkField<Origination> ORIGINATION_FIELD = SdkField.<Origination> builder(MarshallingType.SDK_POJO)
            .memberName("Origination").getter(getter(GetVoiceConnectorOriginationResponse::origination))
            .setter(setter(Builder::origination)).constructor(Origination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINATION_FIELD));

    private final Origination origination;

    private GetVoiceConnectorOriginationResponse(BuilderImpl builder) {
        super(builder);
        this.origination = builder.origination;
    }

    /**
     * <p>
     * The origination setting details.
     * </p>
     * 
     * @return The origination setting details.
     */
    public final Origination origination() {
        return origination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(origination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetVoiceConnectorOriginationResponse)) {
            return false;
        }
        GetVoiceConnectorOriginationResponse other = (GetVoiceConnectorOriginationResponse) obj;
        return Objects.equals(origination(), other.origination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetVoiceConnectorOriginationResponse").add("Origination", origination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Origination":
            return Optional.ofNullable(clazz.cast(origination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetVoiceConnectorOriginationResponse, T> g) {
        return obj -> g.apply((GetVoiceConnectorOriginationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetVoiceConnectorOriginationResponse> {
        /**
         * <p>
         * The origination setting details.
         * </p>
         * 
         * @param origination
         *        The origination setting details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origination(Origination origination);

        /**
         * <p>
         * The origination setting details.
         * </p>
         * This is a convenience that creates an instance of the {@link Origination.Builder} avoiding the need to create
         * one manually via {@link Origination#builder()}.
         *
         * When the {@link Consumer} completes, {@link Origination.Builder#build()} is called immediately and its result
         * is passed to {@link #origination(Origination)}.
         * 
         * @param origination
         *        a consumer that will call methods on {@link Origination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #origination(Origination)
         */
        default Builder origination(Consumer<Origination.Builder> origination) {
            return origination(Origination.builder().applyMutation(origination).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private Origination origination;

        private BuilderImpl() {
        }

        private BuilderImpl(GetVoiceConnectorOriginationResponse model) {
            super(model);
            origination(model.origination);
        }

        public final Origination.Builder getOrigination() {
            return origination != null ? origination.toBuilder() : null;
        }

        @Override
        public final Builder origination(Origination origination) {
            this.origination = origination;
            return this;
        }

        public final void setOrigination(Origination.BuilderImpl origination) {
            this.origination = origination != null ? origination.build() : null;
        }

        @Override
        public GetVoiceConnectorOriginationResponse build() {
            return new GetVoiceConnectorOriginationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
