/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the streaming configuration of an <code>AppInstance</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppInstanceStreamingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AppInstanceStreamingConfiguration.Builder, AppInstanceStreamingConfiguration> {
    private static final SdkField<String> APP_INSTANCE_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppInstanceDataType").getter(getter(AppInstanceStreamingConfiguration::appInstanceDataTypeAsString))
            .setter(setter(Builder::appInstanceDataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceDataType").build())
            .build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(AppInstanceStreamingConfiguration::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_DATA_TYPE_FIELD,
            RESOURCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appInstanceDataType;

    private final String resourceArn;

    private AppInstanceStreamingConfiguration(BuilderImpl builder) {
        this.appInstanceDataType = builder.appInstanceDataType;
        this.resourceArn = builder.resourceArn;
    }

    /**
     * <p>
     * The type of data to be streamed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appInstanceDataType} will return {@link AppInstanceDataType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appInstanceDataTypeAsString}.
     * </p>
     * 
     * @return The type of data to be streamed.
     * @see AppInstanceDataType
     */
    public final AppInstanceDataType appInstanceDataType() {
        return AppInstanceDataType.fromValue(appInstanceDataType);
    }

    /**
     * <p>
     * The type of data to be streamed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #appInstanceDataType} will return {@link AppInstanceDataType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #appInstanceDataTypeAsString}.
     * </p>
     * 
     * @return The type of data to be streamed.
     * @see AppInstanceDataType
     */
    public final String appInstanceDataTypeAsString() {
        return appInstanceDataType;
    }

    /**
     * <p>
     * The resource ARN.
     * </p>
     * 
     * @return The resource ARN.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appInstanceDataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppInstanceStreamingConfiguration)) {
            return false;
        }
        AppInstanceStreamingConfiguration other = (AppInstanceStreamingConfiguration) obj;
        return Objects.equals(appInstanceDataTypeAsString(), other.appInstanceDataTypeAsString())
                && Objects.equals(resourceArn(), other.resourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppInstanceStreamingConfiguration").add("AppInstanceDataType", appInstanceDataTypeAsString())
                .add("ResourceArn", resourceArn() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppInstanceDataType":
            return Optional.ofNullable(clazz.cast(appInstanceDataTypeAsString()));
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppInstanceStreamingConfiguration, T> g) {
        return obj -> g.apply((AppInstanceStreamingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppInstanceStreamingConfiguration> {
        /**
         * <p>
         * The type of data to be streamed.
         * </p>
         * 
         * @param appInstanceDataType
         *        The type of data to be streamed.
         * @see AppInstanceDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppInstanceDataType
         */
        Builder appInstanceDataType(String appInstanceDataType);

        /**
         * <p>
         * The type of data to be streamed.
         * </p>
         * 
         * @param appInstanceDataType
         *        The type of data to be streamed.
         * @see AppInstanceDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppInstanceDataType
         */
        Builder appInstanceDataType(AppInstanceDataType appInstanceDataType);

        /**
         * <p>
         * The resource ARN.
         * </p>
         * 
         * @param resourceArn
         *        The resource ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);
    }

    static final class BuilderImpl implements Builder {
        private String appInstanceDataType;

        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AppInstanceStreamingConfiguration model) {
            appInstanceDataType(model.appInstanceDataType);
            resourceArn(model.resourceArn);
        }

        public final String getAppInstanceDataType() {
            return appInstanceDataType;
        }

        @Override
        public final Builder appInstanceDataType(String appInstanceDataType) {
            this.appInstanceDataType = appInstanceDataType;
            return this;
        }

        @Override
        public final Builder appInstanceDataType(AppInstanceDataType appInstanceDataType) {
            this.appInstanceDataType(appInstanceDataType == null ? null : appInstanceDataType.toString());
            return this;
        }

        public final void setAppInstanceDataType(String appInstanceDataType) {
            this.appInstanceDataType = appInstanceDataType;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public AppInstanceStreamingConfiguration build() {
            return new AppInstanceStreamingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
