/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MemberType {
    USER("User"),
    BOT("Bot"),
    WEBHOOK("Webhook"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MemberType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MemberType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MemberType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MemberType> knownValues() {
        return Stream.of(MemberType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

