/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteChannelMembershipRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, DeleteChannelMembershipRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(DeleteChannelMembershipRequest.getter(DeleteChannelMembershipRequest::channelArn)).setter(DeleteChannelMembershipRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()}).build();
    private static final SdkField<String> MEMBER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberArn").getter(DeleteChannelMembershipRequest.getter(DeleteChannelMembershipRequest::memberArn)).setter(DeleteChannelMembershipRequest.setter(Builder::memberArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("memberArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, MEMBER_ARN_FIELD));
    private final String channelArn;
    private final String memberArn;

    private DeleteChannelMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.memberArn = builder.memberArn;
    }

    public String channelArn() {
        return this.channelArn;
    }

    public String memberArn() {
        return this.memberArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteChannelMembershipRequest)) {
            return false;
        }
        DeleteChannelMembershipRequest other = (DeleteChannelMembershipRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.memberArn(), other.memberArn());
    }

    public String toString() {
        return ToString.builder((String)"DeleteChannelMembershipRequest").add("ChannelArn", (Object)this.channelArn()).add("MemberArn", (Object)this.memberArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "MemberArn": {
                return Optional.ofNullable(clazz.cast(this.memberArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteChannelMembershipRequest, T> g) {
        return obj -> g.apply((DeleteChannelMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String memberArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteChannelMembershipRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.memberArn(model.memberArn);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        public final String getMemberArn() {
            return this.memberArn;
        }

        @Override
        public final Builder memberArn(String memberArn) {
            this.memberArn = memberArn;
            return this;
        }

        public final void setMemberArn(String memberArn) {
            this.memberArn = memberArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteChannelMembershipRequest build() {
            return new DeleteChannelMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteChannelMembershipRequest> {
        public Builder channelArn(String var1);

        public Builder memberArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

