/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.chime.model.ChannelMode;
import software.amazon.awssdk.services.chime.model.ChannelPrivacy;
import software.amazon.awssdk.services.chime.model.ChimeRequest;
import software.amazon.awssdk.services.chime.model.Tag;
import software.amazon.awssdk.services.chime.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateChannelRequest
extends ChimeRequest
implements ToCopyableBuilder<Builder, CreateChannelRequest> {
    private static final SdkField<String> APP_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppInstanceArn").getter(CreateChannelRequest.getter(CreateChannelRequest::appInstanceArn)).setter(CreateChannelRequest.setter(Builder::appInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppInstanceArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateChannelRequest.getter(CreateChannelRequest::name)).setter(CreateChannelRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(CreateChannelRequest.getter(CreateChannelRequest::modeAsString)).setter(CreateChannelRequest.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<String> PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Privacy").getter(CreateChannelRequest.getter(CreateChannelRequest::privacyAsString)).setter(CreateChannelRequest.setter(Builder::privacy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privacy").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(CreateChannelRequest.getter(CreateChannelRequest::metadata)).setter(CreateChannelRequest.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateChannelRequest.getter(CreateChannelRequest::clientRequestToken)).setter(CreateChannelRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateChannelRequest.getter(CreateChannelRequest::tags)).setter(CreateChannelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_INSTANCE_ARN_FIELD, NAME_FIELD, MODE_FIELD, PRIVACY_FIELD, METADATA_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD));
    private final String appInstanceArn;
    private final String name;
    private final String mode;
    private final String privacy;
    private final String metadata;
    private final String clientRequestToken;
    private final List<Tag> tags;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.appInstanceArn = builder.appInstanceArn;
        this.name = builder.name;
        this.mode = builder.mode;
        this.privacy = builder.privacy;
        this.metadata = builder.metadata;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
    }

    public String appInstanceArn() {
        return this.appInstanceArn;
    }

    public String name() {
        return this.name;
    }

    public ChannelMode mode() {
        return ChannelMode.fromValue(this.mode);
    }

    public String modeAsString() {
        return this.mode;
    }

    public ChannelPrivacy privacy() {
        return ChannelPrivacy.fromValue(this.privacy);
    }

    public String privacyAsString() {
        return this.privacy;
    }

    public String metadata() {
        return this.metadata;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privacyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest)((Object)obj);
        return Objects.equals(this.appInstanceArn(), other.appInstanceArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.privacyAsString(), other.privacyAsString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateChannelRequest").add("AppInstanceArn", (Object)this.appInstanceArn()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Mode", (Object)this.modeAsString()).add("Privacy", (Object)this.privacyAsString()).add("Metadata", (Object)(this.metadata() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientRequestToken", (Object)(this.clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.appInstanceArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "Privacy": {
                return Optional.ofNullable(clazz.cast(this.privacyAsString()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateChannelRequest, T> g) {
        return obj -> g.apply((CreateChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeRequest.BuilderImpl
    implements Builder {
        private String appInstanceArn;
        private String name;
        private String mode;
        private String privacy;
        private String metadata;
        private String clientRequestToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            super(model);
            this.appInstanceArn(model.appInstanceArn);
            this.name(model.name);
            this.mode(model.mode);
            this.privacy(model.privacy);
            this.metadata(model.metadata);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
        }

        public final String getAppInstanceArn() {
            return this.appInstanceArn;
        }

        @Override
        public final Builder appInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
            return this;
        }

        public final void setAppInstanceArn(String appInstanceArn) {
            this.appInstanceArn = appInstanceArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMode() {
            return this.mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ChannelMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getPrivacy() {
            return this.privacy;
        }

        @Override
        public final Builder privacy(String privacy) {
            this.privacy = privacy;
            return this;
        }

        @Override
        public final Builder privacy(ChannelPrivacy privacy) {
            this.privacy(privacy == null ? null : privacy.toString());
            return this;
        }

        public final void setPrivacy(String privacy) {
            this.privacy = privacy;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateChannelRequest> {
        public Builder appInstanceArn(String var1);

        public Builder name(String var1);

        public Builder mode(String var1);

        public Builder mode(ChannelMode var1);

        public Builder privacy(String var1);

        public Builder privacy(ChannelPrivacy var1);

        public Builder metadata(String var1);

        public Builder clientRequestToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

