/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For Amazon Chime Voice Connector groups, the Amazon Chime Voice Connectors to which to route inbound calls. Includes
 * priority configuration settings. Limit: 3 <code>VoiceConnectorItems</code> per Amazon Chime Voice Connector group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceConnectorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<VoiceConnectorItem.Builder, VoiceConnectorItem> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceConnectorItem::voiceConnectorId)).setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorId").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(VoiceConnectorItem::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            PRIORITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String voiceConnectorId;

    private final Integer priority;

    private VoiceConnectorItem(BuilderImpl builder) {
        this.voiceConnectorId = builder.voiceConnectorId;
        this.priority = builder.priority;
    }

    /**
     * <p>
     * The Amazon Chime Voice Connector ID.
     * </p>
     * 
     * @return The Amazon Chime Voice Connector ID.
     */
    public String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher priority
     * Amazon Chime Voice Connectors are attempted first.
     * </p>
     * 
     * @return The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher
     *         priority Amazon Chime Voice Connectors are attempted first.
     */
    public Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceConnectorItem)) {
            return false;
        }
        VoiceConnectorItem other = (VoiceConnectorItem) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VoiceConnectorItem").add("VoiceConnectorId", voiceConnectorId()).add("Priority", priority())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceConnectorItem, T> g) {
        return obj -> g.apply((VoiceConnectorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceConnectorItem> {
        /**
         * <p>
         * The Amazon Chime Voice Connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Amazon Chime Voice Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority. Higher
         * priority Amazon Chime Voice Connectors are attempted first.
         * </p>
         * 
         * @param priority
         *        The priority associated with the Amazon Chime Voice Connector, with 1 being the highest priority.
         *        Higher priority Amazon Chime Voice Connectors are attempted first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);
    }

    static final class BuilderImpl implements Builder {
        private String voiceConnectorId;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceConnectorItem model) {
            voiceConnectorId(model.voiceConnectorId);
            priority(model.priority);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public VoiceConnectorItem build() {
            return new VoiceConnectorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
