/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Chime Voice Connector configuration, including outbound host name and encryption settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoiceConnector implements SdkPojo, Serializable, ToCopyableBuilder<VoiceConnector.Builder, VoiceConnector> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceConnector::voiceConnectorId)).setter(setter(Builder::voiceConnectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceConnectorId").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceConnector::awsRegionAsString)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceConnector::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> OUTBOUND_HOST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoiceConnector::outboundHostName)).setter(setter(Builder::outboundHostName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundHostName").build()).build();

    private static final SdkField<Boolean> REQUIRE_ENCRYPTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(VoiceConnector::requireEncryption)).setter(setter(Builder::requireEncryption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireEncryption").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(VoiceConnector::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(VoiceConnector::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD,
            AWS_REGION_FIELD, NAME_FIELD, OUTBOUND_HOST_NAME_FIELD, REQUIRE_ENCRYPTION_FIELD, CREATED_TIMESTAMP_FIELD,
            UPDATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String voiceConnectorId;

    private final String awsRegion;

    private final String name;

    private final String outboundHostName;

    private final Boolean requireEncryption;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private VoiceConnector(BuilderImpl builder) {
        this.voiceConnectorId = builder.voiceConnectorId;
        this.awsRegion = builder.awsRegion;
        this.name = builder.name;
        this.outboundHostName = builder.outboundHostName;
        this.requireEncryption = builder.requireEncryption;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The Amazon Chime Voice Connector ID.
     * </p>
     * 
     * @return The Amazon Chime Voice Connector ID.
     */
    public String voiceConnectorId() {
        return voiceConnectorId;
    }

    /**
     * <p>
     * The AWS Region in which the Amazon Chime Voice Connector is created. Default: <code>us-east-1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsRegion} will
     * return {@link VoiceConnectorAwsRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #awsRegionAsString}.
     * </p>
     * 
     * @return The AWS Region in which the Amazon Chime Voice Connector is created. Default: <code>us-east-1</code>.
     * @see VoiceConnectorAwsRegion
     */
    public VoiceConnectorAwsRegion awsRegion() {
        return VoiceConnectorAwsRegion.fromValue(awsRegion);
    }

    /**
     * <p>
     * The AWS Region in which the Amazon Chime Voice Connector is created. Default: <code>us-east-1</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsRegion} will
     * return {@link VoiceConnectorAwsRegion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #awsRegionAsString}.
     * </p>
     * 
     * @return The AWS Region in which the Amazon Chime Voice Connector is created. Default: <code>us-east-1</code>.
     * @see VoiceConnectorAwsRegion
     */
    public String awsRegionAsString() {
        return awsRegion;
    }

    /**
     * <p>
     * The name of the Amazon Chime Voice Connector.
     * </p>
     * 
     * @return The name of the Amazon Chime Voice Connector.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The outbound host name for the Amazon Chime Voice Connector.
     * </p>
     * 
     * @return The outbound host name for the Amazon Chime Voice Connector.
     */
    public String outboundHostName() {
        return outboundHostName;
    }

    /**
     * <p>
     * Designates whether encryption is required for the Amazon Chime Voice Connector.
     * </p>
     * 
     * @return Designates whether encryption is required for the Amazon Chime Voice Connector.
     */
    public Boolean requireEncryption() {
        return requireEncryption;
    }

    /**
     * <p>
     * The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
     */
    public Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(outboundHostName());
        hashCode = 31 * hashCode + Objects.hashCode(requireEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoiceConnector)) {
            return false;
        }
        VoiceConnector other = (VoiceConnector) obj;
        return Objects.equals(voiceConnectorId(), other.voiceConnectorId())
                && Objects.equals(awsRegionAsString(), other.awsRegionAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(outboundHostName(), other.outboundHostName())
                && Objects.equals(requireEncryption(), other.requireEncryption())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VoiceConnector").add("VoiceConnectorId", voiceConnectorId())
                .add("AwsRegion", awsRegionAsString()).add("Name", name()).add("OutboundHostName", outboundHostName())
                .add("RequireEncryption", requireEncryption()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VoiceConnectorId":
            return Optional.ofNullable(clazz.cast(voiceConnectorId()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegionAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OutboundHostName":
            return Optional.ofNullable(clazz.cast(outboundHostName()));
        case "RequireEncryption":
            return Optional.ofNullable(clazz.cast(requireEncryption()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoiceConnector, T> g) {
        return obj -> g.apply((VoiceConnector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoiceConnector> {
        /**
         * <p>
         * The Amazon Chime Voice Connector ID.
         * </p>
         * 
         * @param voiceConnectorId
         *        The Amazon Chime Voice Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceConnectorId(String voiceConnectorId);

        /**
         * <p>
         * The AWS Region in which the Amazon Chime Voice Connector is created. Default: <code>us-east-1</code>.
         * </p>
         * 
         * @param awsRegion
         *        The AWS Region in which the Amazon Chime Voice Connector is created. Default: <code>us-east-1</code>.
         * @see VoiceConnectorAwsRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceConnectorAwsRegion
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The AWS Region in which the Amazon Chime Voice Connector is created. Default: <code>us-east-1</code>.
         * </p>
         * 
         * @param awsRegion
         *        The AWS Region in which the Amazon Chime Voice Connector is created. Default: <code>us-east-1</code>.
         * @see VoiceConnectorAwsRegion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoiceConnectorAwsRegion
         */
        Builder awsRegion(VoiceConnectorAwsRegion awsRegion);

        /**
         * <p>
         * The name of the Amazon Chime Voice Connector.
         * </p>
         * 
         * @param name
         *        The name of the Amazon Chime Voice Connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The outbound host name for the Amazon Chime Voice Connector.
         * </p>
         * 
         * @param outboundHostName
         *        The outbound host name for the Amazon Chime Voice Connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundHostName(String outboundHostName);

        /**
         * <p>
         * Designates whether encryption is required for the Amazon Chime Voice Connector.
         * </p>
         * 
         * @param requireEncryption
         *        Designates whether encryption is required for the Amazon Chime Voice Connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireEncryption(Boolean requireEncryption);

        /**
         * <p>
         * The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param createdTimestamp
         *        The Amazon Chime Voice Connector creation timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The updated Amazon Chime Voice Connector timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String voiceConnectorId;

        private String awsRegion;

        private String name;

        private String outboundHostName;

        private Boolean requireEncryption;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(VoiceConnector model) {
            voiceConnectorId(model.voiceConnectorId);
            awsRegion(model.awsRegion);
            name(model.name);
            outboundHostName(model.outboundHostName);
            requireEncryption(model.requireEncryption);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getVoiceConnectorId() {
            return voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        public final String getAwsRegionAsString() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        @Override
        public final Builder awsRegion(VoiceConnectorAwsRegion awsRegion) {
            this.awsRegion(awsRegion == null ? null : awsRegion.toString());
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOutboundHostName() {
            return outboundHostName;
        }

        @Override
        public final Builder outboundHostName(String outboundHostName) {
            this.outboundHostName = outboundHostName;
            return this;
        }

        public final void setOutboundHostName(String outboundHostName) {
            this.outboundHostName = outboundHostName;
        }

        public final Boolean getRequireEncryption() {
            return requireEncryption;
        }

        @Override
        public final Builder requireEncryption(Boolean requireEncryption) {
            this.requireEncryption = requireEncryption;
            return this;
        }

        public final void setRequireEncryption(Boolean requireEncryption) {
            this.requireEncryption = requireEncryption;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public VoiceConnector build() {
            return new VoiceConnector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
