/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Termination settings enable your SIP hosts to make outbound calls using your Amazon Chime Voice Connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Termination implements SdkPojo, Serializable, ToCopyableBuilder<Termination.Builder, Termination> {
    private static final SdkField<Integer> CPS_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Termination::cpsLimit)).setter(setter(Builder::cpsLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpsLimit").build()).build();

    private static final SdkField<String> DEFAULT_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Termination::defaultPhoneNumber)).setter(setter(Builder::defaultPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultPhoneNumber").build())
            .build();

    private static final SdkField<List<String>> CALLING_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Termination::callingRegions))
            .setter(setter(Builder::callingRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallingRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CIDR_ALLOWED_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Termination::cidrAllowedList))
            .setter(setter(Builder::cidrAllowedList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrAllowedList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Termination::disabled)).setter(setter(Builder::disabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPS_LIMIT_FIELD,
            DEFAULT_PHONE_NUMBER_FIELD, CALLING_REGIONS_FIELD, CIDR_ALLOWED_LIST_FIELD, DISABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer cpsLimit;

    private final String defaultPhoneNumber;

    private final List<String> callingRegions;

    private final List<String> cidrAllowedList;

    private final Boolean disabled;

    private Termination(BuilderImpl builder) {
        this.cpsLimit = builder.cpsLimit;
        this.defaultPhoneNumber = builder.defaultPhoneNumber;
        this.callingRegions = builder.callingRegions;
        this.cidrAllowedList = builder.cidrAllowedList;
        this.disabled = builder.disabled;
    }

    /**
     * <p>
     * The limit on calls per second. Max value based on account service limit. Default value of 1.
     * </p>
     * 
     * @return The limit on calls per second. Max value based on account service limit. Default value of 1.
     */
    public Integer cpsLimit() {
        return cpsLimit;
    }

    /**
     * <p>
     * The default caller ID phone number.
     * </p>
     * 
     * @return The default caller ID phone number.
     */
    public String defaultPhoneNumber() {
        return defaultPhoneNumber;
    }

    /**
     * Returns true if the CallingRegions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCallingRegions() {
        return callingRegions != null && !(callingRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCallingRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
     */
    public List<String> callingRegions() {
        return callingRegions;
    }

    /**
     * Returns true if the CidrAllowedList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCidrAllowedList() {
        return cidrAllowedList != null && !(cidrAllowedList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses allowed to make calls, in CIDR format. Required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCidrAllowedList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IP addresses allowed to make calls, in CIDR format. Required.
     */
    public List<String> cidrAllowedList() {
        return cidrAllowedList;
    }

    /**
     * <p>
     * When termination settings are disabled, outbound calls can not be made.
     * </p>
     * 
     * @return When termination settings are disabled, outbound calls can not be made.
     */
    public Boolean disabled() {
        return disabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(defaultPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(callingRegions());
        hashCode = 31 * hashCode + Objects.hashCode(cidrAllowedList());
        hashCode = 31 * hashCode + Objects.hashCode(disabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Termination)) {
            return false;
        }
        Termination other = (Termination) obj;
        return Objects.equals(cpsLimit(), other.cpsLimit()) && Objects.equals(defaultPhoneNumber(), other.defaultPhoneNumber())
                && Objects.equals(callingRegions(), other.callingRegions())
                && Objects.equals(cidrAllowedList(), other.cidrAllowedList()) && Objects.equals(disabled(), other.disabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Termination").add("CpsLimit", cpsLimit())
                .add("DefaultPhoneNumber", defaultPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CallingRegions", callingRegions()).add("CidrAllowedList", cidrAllowedList()).add("Disabled", disabled())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CpsLimit":
            return Optional.ofNullable(clazz.cast(cpsLimit()));
        case "DefaultPhoneNumber":
            return Optional.ofNullable(clazz.cast(defaultPhoneNumber()));
        case "CallingRegions":
            return Optional.ofNullable(clazz.cast(callingRegions()));
        case "CidrAllowedList":
            return Optional.ofNullable(clazz.cast(cidrAllowedList()));
        case "Disabled":
            return Optional.ofNullable(clazz.cast(disabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Termination, T> g) {
        return obj -> g.apply((Termination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Termination> {
        /**
         * <p>
         * The limit on calls per second. Max value based on account service limit. Default value of 1.
         * </p>
         * 
         * @param cpsLimit
         *        The limit on calls per second. Max value based on account service limit. Default value of 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpsLimit(Integer cpsLimit);

        /**
         * <p>
         * The default caller ID phone number.
         * </p>
         * 
         * @param defaultPhoneNumber
         *        The default caller ID phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultPhoneNumber(String defaultPhoneNumber);

        /**
         * <p>
         * The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
         * </p>
         * 
         * @param callingRegions
         *        The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callingRegions(Collection<String> callingRegions);

        /**
         * <p>
         * The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
         * </p>
         * 
         * @param callingRegions
         *        The countries to which calls are allowed, in ISO 3166-1 alpha-2 format. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callingRegions(String... callingRegions);

        /**
         * <p>
         * The IP addresses allowed to make calls, in CIDR format. Required.
         * </p>
         * 
         * @param cidrAllowedList
         *        The IP addresses allowed to make calls, in CIDR format. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowedList(Collection<String> cidrAllowedList);

        /**
         * <p>
         * The IP addresses allowed to make calls, in CIDR format. Required.
         * </p>
         * 
         * @param cidrAllowedList
         *        The IP addresses allowed to make calls, in CIDR format. Required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrAllowedList(String... cidrAllowedList);

        /**
         * <p>
         * When termination settings are disabled, outbound calls can not be made.
         * </p>
         * 
         * @param disabled
         *        When termination settings are disabled, outbound calls can not be made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabled(Boolean disabled);
    }

    static final class BuilderImpl implements Builder {
        private Integer cpsLimit;

        private String defaultPhoneNumber;

        private List<String> callingRegions = DefaultSdkAutoConstructList.getInstance();

        private List<String> cidrAllowedList = DefaultSdkAutoConstructList.getInstance();

        private Boolean disabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Termination model) {
            cpsLimit(model.cpsLimit);
            defaultPhoneNumber(model.defaultPhoneNumber);
            callingRegions(model.callingRegions);
            cidrAllowedList(model.cidrAllowedList);
            disabled(model.disabled);
        }

        public final Integer getCpsLimit() {
            return cpsLimit;
        }

        @Override
        public final Builder cpsLimit(Integer cpsLimit) {
            this.cpsLimit = cpsLimit;
            return this;
        }

        public final void setCpsLimit(Integer cpsLimit) {
            this.cpsLimit = cpsLimit;
        }

        public final String getDefaultPhoneNumber() {
            return defaultPhoneNumber;
        }

        @Override
        public final Builder defaultPhoneNumber(String defaultPhoneNumber) {
            this.defaultPhoneNumber = defaultPhoneNumber;
            return this;
        }

        public final void setDefaultPhoneNumber(String defaultPhoneNumber) {
            this.defaultPhoneNumber = defaultPhoneNumber;
        }

        public final Collection<String> getCallingRegions() {
            return callingRegions;
        }

        @Override
        public final Builder callingRegions(Collection<String> callingRegions) {
            this.callingRegions = CallingRegionListCopier.copy(callingRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder callingRegions(String... callingRegions) {
            callingRegions(Arrays.asList(callingRegions));
            return this;
        }

        public final void setCallingRegions(Collection<String> callingRegions) {
            this.callingRegions = CallingRegionListCopier.copy(callingRegions);
        }

        public final Collection<String> getCidrAllowedList() {
            return cidrAllowedList;
        }

        @Override
        public final Builder cidrAllowedList(Collection<String> cidrAllowedList) {
            this.cidrAllowedList = StringListCopier.copy(cidrAllowedList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrAllowedList(String... cidrAllowedList) {
            cidrAllowedList(Arrays.asList(cidrAllowedList));
            return this;
        }

        public final void setCidrAllowedList(Collection<String> cidrAllowedList) {
            this.cidrAllowedList = StringListCopier.copy(cidrAllowedList);
        }

        public final Boolean getDisabled() {
            return disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public Termination build() {
            return new Termination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
