/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Chime chat room details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Room implements SdkPojo, Serializable, ToCopyableBuilder<Room.Builder, Room> {
    private static final SdkField<String> ROOM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Room::roomId)).setter(setter(Builder::roomId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoomId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Room::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Room::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Room::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Room::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Room::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOM_ID_FIELD, NAME_FIELD,
            ACCOUNT_ID_FIELD, CREATED_BY_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roomId;

    private final String name;

    private final String accountId;

    private final String createdBy;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private Room(BuilderImpl builder) {
        this.roomId = builder.roomId;
        this.name = builder.name;
        this.accountId = builder.accountId;
        this.createdBy = builder.createdBy;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The room ID.
     * </p>
     * 
     * @return The room ID.
     */
    public String roomId() {
        return roomId;
    }

    /**
     * <p>
     * The room name.
     * </p>
     * 
     * @return The room name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Chime account ID.
     * </p>
     * 
     * @return The Amazon Chime account ID.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The identifier of the room creator.
     * </p>
     * 
     * @return The identifier of the room creator.
     */
    public String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The room creation timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The room creation timestamp, in ISO 8601 format.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The room update timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The room update timestamp, in ISO 8601 format.
     */
    public Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roomId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Room)) {
            return false;
        }
        Room other = (Room) obj;
        return Objects.equals(roomId(), other.roomId()) && Objects.equals(name(), other.name())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Room").add("RoomId", roomId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("AccountId", accountId())
                .add("CreatedBy", createdBy()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RoomId":
            return Optional.ofNullable(clazz.cast(roomId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Room, T> g) {
        return obj -> g.apply((Room) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Room> {
        /**
         * <p>
         * The room ID.
         * </p>
         * 
         * @param roomId
         *        The room ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roomId(String roomId);

        /**
         * <p>
         * The room name.
         * </p>
         * 
         * @param name
         *        The room name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Chime account ID.
         * </p>
         * 
         * @param accountId
         *        The Amazon Chime account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The identifier of the room creator.
         * </p>
         * 
         * @param createdBy
         *        The identifier of the room creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The room creation timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param createdTimestamp
         *        The room creation timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The room update timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The room update timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String roomId;

        private String name;

        private String accountId;

        private String createdBy;

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Room model) {
            roomId(model.roomId);
            name(model.name);
            accountId(model.accountId);
            createdBy(model.createdBy);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getRoomId() {
            return roomId;
        }

        @Override
        public final Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public final void setRoomId(String roomId) {
            this.roomId = roomId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public Room build() {
            return new Room(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
