/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a phone number order created for Amazon Chime.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PhoneNumberOrder implements SdkPojo, Serializable,
        ToCopyableBuilder<PhoneNumberOrder.Builder, PhoneNumberOrder> {
    private static final SdkField<String> PHONE_NUMBER_ORDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PhoneNumberOrder::phoneNumberOrderId)).setter(setter(Builder::phoneNumberOrderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberOrderId").build())
            .build();

    private static final SdkField<String> PRODUCT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PhoneNumberOrder::productTypeAsString)).setter(setter(Builder::productType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PhoneNumberOrder::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<OrderedPhoneNumber>> ORDERED_PHONE_NUMBERS_FIELD = SdkField
            .<List<OrderedPhoneNumber>> builder(MarshallingType.LIST)
            .getter(getter(PhoneNumberOrder::orderedPhoneNumbers))
            .setter(setter(Builder::orderedPhoneNumbers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedPhoneNumbers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OrderedPhoneNumber> builder(MarshallingType.SDK_POJO)
                                            .constructor(OrderedPhoneNumber::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PhoneNumberOrder::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(PhoneNumberOrder::updatedTimestamp))
            .setter(setter(Builder::updatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ORDER_ID_FIELD,
            PRODUCT_TYPE_FIELD, STATUS_FIELD, ORDERED_PHONE_NUMBERS_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String phoneNumberOrderId;

    private final String productType;

    private final String status;

    private final List<OrderedPhoneNumber> orderedPhoneNumbers;

    private final Instant createdTimestamp;

    private final Instant updatedTimestamp;

    private PhoneNumberOrder(BuilderImpl builder) {
        this.phoneNumberOrderId = builder.phoneNumberOrderId;
        this.productType = builder.productType;
        this.status = builder.status;
        this.orderedPhoneNumbers = builder.orderedPhoneNumbers;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    /**
     * <p>
     * The phone number order ID.
     * </p>
     * 
     * @return The phone number order ID.
     */
    public String phoneNumberOrderId() {
        return phoneNumberOrderId;
    }

    /**
     * <p>
     * The phone number order product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The phone number order product type.
     * @see PhoneNumberProductType
     */
    public PhoneNumberProductType productType() {
        return PhoneNumberProductType.fromValue(productType);
    }

    /**
     * <p>
     * The phone number order product type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #productType} will
     * return {@link PhoneNumberProductType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #productTypeAsString}.
     * </p>
     * 
     * @return The phone number order product type.
     * @see PhoneNumberProductType
     */
    public String productTypeAsString() {
        return productType;
    }

    /**
     * <p>
     * The status of the phone number order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PhoneNumberOrderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the phone number order.
     * @see PhoneNumberOrderStatus
     */
    public PhoneNumberOrderStatus status() {
        return PhoneNumberOrderStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the phone number order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PhoneNumberOrderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the phone number order.
     * @see PhoneNumberOrderStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Returns true if the OrderedPhoneNumbers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasOrderedPhoneNumbers() {
        return orderedPhoneNumbers != null && !(orderedPhoneNumbers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ordered phone number details, such as the phone number in E.164 format and the phone number status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrderedPhoneNumbers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ordered phone number details, such as the phone number in E.164 format and the phone number status.
     */
    public List<OrderedPhoneNumber> orderedPhoneNumbers() {
        return orderedPhoneNumbers;
    }

    /**
     * <p>
     * The phone number order creation timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The phone number order creation timestamp, in ISO 8601 format.
     */
    public Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The updated phone number order timestamp, in ISO 8601 format.
     * </p>
     * 
     * @return The updated phone number order timestamp, in ISO 8601 format.
     */
    public Instant updatedTimestamp() {
        return updatedTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberOrderId());
        hashCode = 31 * hashCode + Objects.hashCode(productTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orderedPhoneNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(updatedTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoneNumberOrder)) {
            return false;
        }
        PhoneNumberOrder other = (PhoneNumberOrder) obj;
        return Objects.equals(phoneNumberOrderId(), other.phoneNumberOrderId())
                && Objects.equals(productTypeAsString(), other.productTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(orderedPhoneNumbers(), other.orderedPhoneNumbers())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(updatedTimestamp(), other.updatedTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PhoneNumberOrder").add("PhoneNumberOrderId", phoneNumberOrderId())
                .add("ProductType", productTypeAsString()).add("Status", statusAsString())
                .add("OrderedPhoneNumbers", orderedPhoneNumbers()).add("CreatedTimestamp", createdTimestamp())
                .add("UpdatedTimestamp", updatedTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberOrderId":
            return Optional.ofNullable(clazz.cast(phoneNumberOrderId()));
        case "ProductType":
            return Optional.ofNullable(clazz.cast(productTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "OrderedPhoneNumbers":
            return Optional.ofNullable(clazz.cast(orderedPhoneNumbers()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "UpdatedTimestamp":
            return Optional.ofNullable(clazz.cast(updatedTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PhoneNumberOrder, T> g) {
        return obj -> g.apply((PhoneNumberOrder) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PhoneNumberOrder> {
        /**
         * <p>
         * The phone number order ID.
         * </p>
         * 
         * @param phoneNumberOrderId
         *        The phone number order ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberOrderId(String phoneNumberOrderId);

        /**
         * <p>
         * The phone number order product type.
         * </p>
         * 
         * @param productType
         *        The phone number order product type.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(String productType);

        /**
         * <p>
         * The phone number order product type.
         * </p>
         * 
         * @param productType
         *        The phone number order product type.
         * @see PhoneNumberProductType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberProductType
         */
        Builder productType(PhoneNumberProductType productType);

        /**
         * <p>
         * The status of the phone number order.
         * </p>
         * 
         * @param status
         *        The status of the phone number order.
         * @see PhoneNumberOrderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberOrderStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the phone number order.
         * </p>
         * 
         * @param status
         *        The status of the phone number order.
         * @see PhoneNumberOrderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PhoneNumberOrderStatus
         */
        Builder status(PhoneNumberOrderStatus status);

        /**
         * <p>
         * The ordered phone number details, such as the phone number in E.164 format and the phone number status.
         * </p>
         * 
         * @param orderedPhoneNumbers
         *        The ordered phone number details, such as the phone number in E.164 format and the phone number
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedPhoneNumbers(Collection<OrderedPhoneNumber> orderedPhoneNumbers);

        /**
         * <p>
         * The ordered phone number details, such as the phone number in E.164 format and the phone number status.
         * </p>
         * 
         * @param orderedPhoneNumbers
         *        The ordered phone number details, such as the phone number in E.164 format and the phone number
         *        status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderedPhoneNumbers(OrderedPhoneNumber... orderedPhoneNumbers);

        /**
         * <p>
         * The ordered phone number details, such as the phone number in E.164 format and the phone number status.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OrderedPhoneNumber>.Builder} avoiding the
         * need to create one manually via {@link List<OrderedPhoneNumber>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OrderedPhoneNumber>.Builder#build()} is called immediately
         * and its result is passed to {@link #orderedPhoneNumbers(List<OrderedPhoneNumber>)}.
         * 
         * @param orderedPhoneNumbers
         *        a consumer that will call methods on {@link List<OrderedPhoneNumber>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orderedPhoneNumbers(List<OrderedPhoneNumber>)
         */
        Builder orderedPhoneNumbers(Consumer<OrderedPhoneNumber.Builder>... orderedPhoneNumbers);

        /**
         * <p>
         * The phone number order creation timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param createdTimestamp
         *        The phone number order creation timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The updated phone number order timestamp, in ISO 8601 format.
         * </p>
         * 
         * @param updatedTimestamp
         *        The updated phone number order timestamp, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedTimestamp(Instant updatedTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String phoneNumberOrderId;

        private String productType;

        private String status;

        private List<OrderedPhoneNumber> orderedPhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private Instant createdTimestamp;

        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(PhoneNumberOrder model) {
            phoneNumberOrderId(model.phoneNumberOrderId);
            productType(model.productType);
            status(model.status);
            orderedPhoneNumbers(model.orderedPhoneNumbers);
            createdTimestamp(model.createdTimestamp);
            updatedTimestamp(model.updatedTimestamp);
        }

        public final String getPhoneNumberOrderId() {
            return phoneNumberOrderId;
        }

        @Override
        public final Builder phoneNumberOrderId(String phoneNumberOrderId) {
            this.phoneNumberOrderId = phoneNumberOrderId;
            return this;
        }

        public final void setPhoneNumberOrderId(String phoneNumberOrderId) {
            this.phoneNumberOrderId = phoneNumberOrderId;
        }

        public final String getProductTypeAsString() {
            return productType;
        }

        @Override
        public final Builder productType(String productType) {
            this.productType = productType;
            return this;
        }

        @Override
        public final Builder productType(PhoneNumberProductType productType) {
            this.productType(productType == null ? null : productType.toString());
            return this;
        }

        public final void setProductType(String productType) {
            this.productType = productType;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PhoneNumberOrderStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<OrderedPhoneNumber.Builder> getOrderedPhoneNumbers() {
            return orderedPhoneNumbers != null ? orderedPhoneNumbers.stream().map(OrderedPhoneNumber::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderedPhoneNumbers(Collection<OrderedPhoneNumber> orderedPhoneNumbers) {
            this.orderedPhoneNumbers = OrderedPhoneNumberListCopier.copy(orderedPhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedPhoneNumbers(OrderedPhoneNumber... orderedPhoneNumbers) {
            orderedPhoneNumbers(Arrays.asList(orderedPhoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedPhoneNumbers(Consumer<OrderedPhoneNumber.Builder>... orderedPhoneNumbers) {
            orderedPhoneNumbers(Stream.of(orderedPhoneNumbers).map(c -> OrderedPhoneNumber.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOrderedPhoneNumbers(Collection<OrderedPhoneNumber.BuilderImpl> orderedPhoneNumbers) {
            this.orderedPhoneNumbers = OrderedPhoneNumberListCopier.copyFromBuilder(orderedPhoneNumbers);
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        public final Instant getUpdatedTimestamp() {
            return updatedTimestamp;
        }

        @Override
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        public PhoneNumberOrder build() {
            return new PhoneNumberOrder(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
