/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of endpoints used by clients to connect to the media service group for a Amazon Chime SDK meeting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaPlacement implements SdkPojo, Serializable, ToCopyableBuilder<MediaPlacement.Builder, MediaPlacement> {
    private static final SdkField<String> AUDIO_HOST_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MediaPlacement::audioHostUrl)).setter(setter(Builder::audioHostUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioHostUrl").build()).build();

    private static final SdkField<String> SCREEN_DATA_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MediaPlacement::screenDataUrl)).setter(setter(Builder::screenDataUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScreenDataUrl").build()).build();

    private static final SdkField<String> SCREEN_SHARING_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MediaPlacement::screenSharingUrl)).setter(setter(Builder::screenSharingUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScreenSharingUrl").build()).build();

    private static final SdkField<String> SCREEN_VIEWING_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MediaPlacement::screenViewingUrl)).setter(setter(Builder::screenViewingUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScreenViewingUrl").build()).build();

    private static final SdkField<String> SIGNALING_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MediaPlacement::signalingUrl)).setter(setter(Builder::signalingUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignalingUrl").build()).build();

    private static final SdkField<String> TURN_CONTROL_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MediaPlacement::turnControlUrl)).setter(setter(Builder::turnControlUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TurnControlUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_HOST_URL_FIELD,
            SCREEN_DATA_URL_FIELD, SCREEN_SHARING_URL_FIELD, SCREEN_VIEWING_URL_FIELD, SIGNALING_URL_FIELD,
            TURN_CONTROL_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String audioHostUrl;

    private final String screenDataUrl;

    private final String screenSharingUrl;

    private final String screenViewingUrl;

    private final String signalingUrl;

    private final String turnControlUrl;

    private MediaPlacement(BuilderImpl builder) {
        this.audioHostUrl = builder.audioHostUrl;
        this.screenDataUrl = builder.screenDataUrl;
        this.screenSharingUrl = builder.screenSharingUrl;
        this.screenViewingUrl = builder.screenViewingUrl;
        this.signalingUrl = builder.signalingUrl;
        this.turnControlUrl = builder.turnControlUrl;
    }

    /**
     * <p>
     * The audio host URL.
     * </p>
     * 
     * @return The audio host URL.
     */
    public String audioHostUrl() {
        return audioHostUrl;
    }

    /**
     * <p>
     * The screen data URL.
     * </p>
     * 
     * @return The screen data URL.
     */
    public String screenDataUrl() {
        return screenDataUrl;
    }

    /**
     * <p>
     * The screen sharing URL.
     * </p>
     * 
     * @return The screen sharing URL.
     */
    public String screenSharingUrl() {
        return screenSharingUrl;
    }

    /**
     * <p>
     * The screen viewing URL.
     * </p>
     * 
     * @return The screen viewing URL.
     */
    public String screenViewingUrl() {
        return screenViewingUrl;
    }

    /**
     * <p>
     * The signaling URL.
     * </p>
     * 
     * @return The signaling URL.
     */
    public String signalingUrl() {
        return signalingUrl;
    }

    /**
     * <p>
     * The turn control URL.
     * </p>
     * 
     * @return The turn control URL.
     */
    public String turnControlUrl() {
        return turnControlUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioHostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(screenDataUrl());
        hashCode = 31 * hashCode + Objects.hashCode(screenSharingUrl());
        hashCode = 31 * hashCode + Objects.hashCode(screenViewingUrl());
        hashCode = 31 * hashCode + Objects.hashCode(signalingUrl());
        hashCode = 31 * hashCode + Objects.hashCode(turnControlUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPlacement)) {
            return false;
        }
        MediaPlacement other = (MediaPlacement) obj;
        return Objects.equals(audioHostUrl(), other.audioHostUrl()) && Objects.equals(screenDataUrl(), other.screenDataUrl())
                && Objects.equals(screenSharingUrl(), other.screenSharingUrl())
                && Objects.equals(screenViewingUrl(), other.screenViewingUrl())
                && Objects.equals(signalingUrl(), other.signalingUrl())
                && Objects.equals(turnControlUrl(), other.turnControlUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MediaPlacement").add("AudioHostUrl", audioHostUrl()).add("ScreenDataUrl", screenDataUrl())
                .add("ScreenSharingUrl", screenSharingUrl()).add("ScreenViewingUrl", screenViewingUrl())
                .add("SignalingUrl", signalingUrl()).add("TurnControlUrl", turnControlUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AudioHostUrl":
            return Optional.ofNullable(clazz.cast(audioHostUrl()));
        case "ScreenDataUrl":
            return Optional.ofNullable(clazz.cast(screenDataUrl()));
        case "ScreenSharingUrl":
            return Optional.ofNullable(clazz.cast(screenSharingUrl()));
        case "ScreenViewingUrl":
            return Optional.ofNullable(clazz.cast(screenViewingUrl()));
        case "SignalingUrl":
            return Optional.ofNullable(clazz.cast(signalingUrl()));
        case "TurnControlUrl":
            return Optional.ofNullable(clazz.cast(turnControlUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MediaPlacement, T> g) {
        return obj -> g.apply((MediaPlacement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaPlacement> {
        /**
         * <p>
         * The audio host URL.
         * </p>
         * 
         * @param audioHostUrl
         *        The audio host URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioHostUrl(String audioHostUrl);

        /**
         * <p>
         * The screen data URL.
         * </p>
         * 
         * @param screenDataUrl
         *        The screen data URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder screenDataUrl(String screenDataUrl);

        /**
         * <p>
         * The screen sharing URL.
         * </p>
         * 
         * @param screenSharingUrl
         *        The screen sharing URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder screenSharingUrl(String screenSharingUrl);

        /**
         * <p>
         * The screen viewing URL.
         * </p>
         * 
         * @param screenViewingUrl
         *        The screen viewing URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder screenViewingUrl(String screenViewingUrl);

        /**
         * <p>
         * The signaling URL.
         * </p>
         * 
         * @param signalingUrl
         *        The signaling URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signalingUrl(String signalingUrl);

        /**
         * <p>
         * The turn control URL.
         * </p>
         * 
         * @param turnControlUrl
         *        The turn control URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turnControlUrl(String turnControlUrl);
    }

    static final class BuilderImpl implements Builder {
        private String audioHostUrl;

        private String screenDataUrl;

        private String screenSharingUrl;

        private String screenViewingUrl;

        private String signalingUrl;

        private String turnControlUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPlacement model) {
            audioHostUrl(model.audioHostUrl);
            screenDataUrl(model.screenDataUrl);
            screenSharingUrl(model.screenSharingUrl);
            screenViewingUrl(model.screenViewingUrl);
            signalingUrl(model.signalingUrl);
            turnControlUrl(model.turnControlUrl);
        }

        public final String getAudioHostUrl() {
            return audioHostUrl;
        }

        @Override
        public final Builder audioHostUrl(String audioHostUrl) {
            this.audioHostUrl = audioHostUrl;
            return this;
        }

        public final void setAudioHostUrl(String audioHostUrl) {
            this.audioHostUrl = audioHostUrl;
        }

        public final String getScreenDataUrl() {
            return screenDataUrl;
        }

        @Override
        public final Builder screenDataUrl(String screenDataUrl) {
            this.screenDataUrl = screenDataUrl;
            return this;
        }

        public final void setScreenDataUrl(String screenDataUrl) {
            this.screenDataUrl = screenDataUrl;
        }

        public final String getScreenSharingUrl() {
            return screenSharingUrl;
        }

        @Override
        public final Builder screenSharingUrl(String screenSharingUrl) {
            this.screenSharingUrl = screenSharingUrl;
            return this;
        }

        public final void setScreenSharingUrl(String screenSharingUrl) {
            this.screenSharingUrl = screenSharingUrl;
        }

        public final String getScreenViewingUrl() {
            return screenViewingUrl;
        }

        @Override
        public final Builder screenViewingUrl(String screenViewingUrl) {
            this.screenViewingUrl = screenViewingUrl;
            return this;
        }

        public final void setScreenViewingUrl(String screenViewingUrl) {
            this.screenViewingUrl = screenViewingUrl;
        }

        public final String getSignalingUrl() {
            return signalingUrl;
        }

        @Override
        public final Builder signalingUrl(String signalingUrl) {
            this.signalingUrl = signalingUrl;
            return this;
        }

        public final void setSignalingUrl(String signalingUrl) {
            this.signalingUrl = signalingUrl;
        }

        public final String getTurnControlUrl() {
            return turnControlUrl;
        }

        @Override
        public final Builder turnControlUrl(String turnControlUrl) {
            this.turnControlUrl = turnControlUrl;
            return this;
        }

        public final void setTurnControlUrl(String turnControlUrl) {
            this.turnControlUrl = turnControlUrl;
        }

        @Override
        public MediaPlacement build() {
            return new MediaPlacement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
