/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPhoneNumberOrdersResponse extends ChimeResponse implements
        ToCopyableBuilder<ListPhoneNumberOrdersResponse.Builder, ListPhoneNumberOrdersResponse> {
    private static final SdkField<List<PhoneNumberOrder>> PHONE_NUMBER_ORDERS_FIELD = SdkField
            .<List<PhoneNumberOrder>> builder(MarshallingType.LIST)
            .getter(getter(ListPhoneNumberOrdersResponse::phoneNumberOrders))
            .setter(setter(Builder::phoneNumberOrders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberOrders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PhoneNumberOrder> builder(MarshallingType.SDK_POJO)
                                            .constructor(PhoneNumberOrder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListPhoneNumberOrdersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ORDERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PhoneNumberOrder> phoneNumberOrders;

    private final String nextToken;

    private ListPhoneNumberOrdersResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumberOrders = builder.phoneNumberOrders;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the PhoneNumberOrders property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPhoneNumberOrders() {
        return phoneNumberOrders != null && !(phoneNumberOrders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The phone number order details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPhoneNumberOrders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The phone number order details.
     */
    public List<PhoneNumberOrder> phoneNumberOrders() {
        return phoneNumberOrders;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumberOrders());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumberOrdersResponse)) {
            return false;
        }
        ListPhoneNumberOrdersResponse other = (ListPhoneNumberOrdersResponse) obj;
        return Objects.equals(phoneNumberOrders(), other.phoneNumberOrders()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPhoneNumberOrdersResponse").add("PhoneNumberOrders", phoneNumberOrders())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PhoneNumberOrders":
            return Optional.ofNullable(clazz.cast(phoneNumberOrders()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumberOrdersResponse, T> g) {
        return obj -> g.apply((ListPhoneNumberOrdersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPhoneNumberOrdersResponse> {
        /**
         * <p>
         * The phone number order details.
         * </p>
         * 
         * @param phoneNumberOrders
         *        The phone number order details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberOrders(Collection<PhoneNumberOrder> phoneNumberOrders);

        /**
         * <p>
         * The phone number order details.
         * </p>
         * 
         * @param phoneNumberOrders
         *        The phone number order details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumberOrders(PhoneNumberOrder... phoneNumberOrders);

        /**
         * <p>
         * The phone number order details.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PhoneNumberOrder>.Builder} avoiding the
         * need to create one manually via {@link List<PhoneNumberOrder>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PhoneNumberOrder>.Builder#build()} is called immediately and
         * its result is passed to {@link #phoneNumberOrders(List<PhoneNumberOrder>)}.
         * 
         * @param phoneNumberOrders
         *        a consumer that will call methods on {@link List<PhoneNumberOrder>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumberOrders(List<PhoneNumberOrder>)
         */
        Builder phoneNumberOrders(Consumer<PhoneNumberOrder.Builder>... phoneNumberOrders);

        /**
         * <p>
         * The token to use to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<PhoneNumberOrder> phoneNumberOrders = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumberOrdersResponse model) {
            super(model);
            phoneNumberOrders(model.phoneNumberOrders);
            nextToken(model.nextToken);
        }

        public final Collection<PhoneNumberOrder.Builder> getPhoneNumberOrders() {
            return phoneNumberOrders != null ? phoneNumberOrders.stream().map(PhoneNumberOrder::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phoneNumberOrders(Collection<PhoneNumberOrder> phoneNumberOrders) {
            this.phoneNumberOrders = PhoneNumberOrderListCopier.copy(phoneNumberOrders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberOrders(PhoneNumberOrder... phoneNumberOrders) {
            phoneNumberOrders(Arrays.asList(phoneNumberOrders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberOrders(Consumer<PhoneNumberOrder.Builder>... phoneNumberOrders) {
            phoneNumberOrders(Stream.of(phoneNumberOrders).map(c -> PhoneNumberOrder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPhoneNumberOrders(Collection<PhoneNumberOrder.BuilderImpl> phoneNumberOrders) {
            this.phoneNumberOrders = PhoneNumberOrderListCopier.copyFromBuilder(phoneNumberOrders);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPhoneNumberOrdersResponse build() {
            return new ListPhoneNumberOrdersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
