/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUserSettingsResponse extends ChimeResponse implements
        ToCopyableBuilder<GetUserSettingsResponse.Builder, GetUserSettingsResponse> {
    private static final SdkField<UserSettings> USER_SETTINGS_FIELD = SdkField.<UserSettings> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetUserSettingsResponse::userSettings)).setter(setter(Builder::userSettings))
            .constructor(UserSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_SETTINGS_FIELD));

    private final UserSettings userSettings;

    private GetUserSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.userSettings = builder.userSettings;
    }

    /**
     * <p>
     * The user settings.
     * </p>
     * 
     * @return The user settings.
     */
    public UserSettings userSettings() {
        return userSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userSettings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUserSettingsResponse)) {
            return false;
        }
        GetUserSettingsResponse other = (GetUserSettingsResponse) obj;
        return Objects.equals(userSettings(), other.userSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetUserSettingsResponse").add("UserSettings", userSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserSettings":
            return Optional.ofNullable(clazz.cast(userSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetUserSettingsResponse, T> g) {
        return obj -> g.apply((GetUserSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUserSettingsResponse> {
        /**
         * <p>
         * The user settings.
         * </p>
         * 
         * @param userSettings
         *        The user settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(UserSettings userSettings);

        /**
         * <p>
         * The user settings.
         * </p>
         * This is a convenience that creates an instance of the {@link UserSettings.Builder} avoiding the need to
         * create one manually via {@link UserSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #userSettings(UserSettings)}.
         * 
         * @param userSettings
         *        a consumer that will call methods on {@link UserSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userSettings(UserSettings)
         */
        default Builder userSettings(Consumer<UserSettings.Builder> userSettings) {
            return userSettings(UserSettings.builder().applyMutation(userSettings).build());
        }
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private UserSettings userSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUserSettingsResponse model) {
            super(model);
            userSettings(model.userSettings);
        }

        public final UserSettings.Builder getUserSettings() {
            return userSettings != null ? userSettings.toBuilder() : null;
        }

        @Override
        public final Builder userSettings(UserSettings userSettings) {
            this.userSettings = userSettings;
            return this;
        }

        public final void setUserSettings(UserSettings.BuilderImpl userSettings) {
            this.userSettings = userSettings != null ? userSettings.build() : null;
        }

        @Override
        public GetUserSettingsResponse build() {
            return new GetUserSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
