/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMeetingRequest extends ChimeRequest implements
        ToCopyableBuilder<CreateMeetingRequest.Builder, CreateMeetingRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateMeetingRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MEETING_HOST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateMeetingRequest::meetingHostId)).setter(setter(Builder::meetingHostId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingHostId").build()).build();

    private static final SdkField<String> MEDIA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateMeetingRequest::mediaRegion)).setter(setter(Builder::mediaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaRegion").build()).build();

    private static final SdkField<MeetingNotificationConfiguration> NOTIFICATIONS_CONFIGURATION_FIELD = SdkField
            .<MeetingNotificationConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateMeetingRequest::notificationsConfiguration))
            .setter(setter(Builder::notificationsConfiguration))
            .constructor(MeetingNotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationsConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            MEETING_HOST_ID_FIELD, MEDIA_REGION_FIELD, NOTIFICATIONS_CONFIGURATION_FIELD));

    private final String clientRequestToken;

    private final String meetingHostId;

    private final String mediaRegion;

    private final MeetingNotificationConfiguration notificationsConfiguration;

    private CreateMeetingRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.meetingHostId = builder.meetingHostId;
        this.mediaRegion = builder.mediaRegion;
        this.notificationsConfiguration = builder.notificationsConfiguration;
    }

    /**
     * <p>
     * The unique identifier for the client request. Use a different token for different meetings.
     * </p>
     * 
     * @return The unique identifier for the client request. Use a different token for different meetings.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public String meetingHostId() {
        return meetingHostId;
    }

    /**
     * <p>
     * The Region in which to create the meeting. Available values: <code>ap-northeast-1</code>,
     * <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>, <code>eu-central-1</code>,
     * <code>eu-north-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>, <code>eu-west-3</code>,
     * <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>, <code>us-west-1</code>,
     * <code>us-west-2</code>.
     * </p>
     * 
     * @return The Region in which to create the meeting. Available values: <code>ap-northeast-1</code>,
     *         <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
     *         <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>,
     *         <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>,
     *         <code>us-west-1</code>, <code>us-west-2</code>.
     */
    public String mediaRegion() {
        return mediaRegion;
    }

    /**
     * <p>
     * The configuration for resource targets to receive notifications when meeting and attendee events occur.
     * </p>
     * 
     * @return The configuration for resource targets to receive notifications when meeting and attendee events occur.
     */
    public MeetingNotificationConfiguration notificationsConfiguration() {
        return notificationsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(meetingHostId());
        hashCode = 31 * hashCode + Objects.hashCode(mediaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(notificationsConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMeetingRequest)) {
            return false;
        }
        CreateMeetingRequest other = (CreateMeetingRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(meetingHostId(), other.meetingHostId()) && Objects.equals(mediaRegion(), other.mediaRegion())
                && Objects.equals(notificationsConfiguration(), other.notificationsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateMeetingRequest")
                .add("ClientRequestToken", clientRequestToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MeetingHostId", meetingHostId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MediaRegion", mediaRegion()).add("NotificationsConfiguration", notificationsConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "MeetingHostId":
            return Optional.ofNullable(clazz.cast(meetingHostId()));
        case "MediaRegion":
            return Optional.ofNullable(clazz.cast(mediaRegion()));
        case "NotificationsConfiguration":
            return Optional.ofNullable(clazz.cast(notificationsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMeetingRequest, T> g) {
        return obj -> g.apply((CreateMeetingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMeetingRequest> {
        /**
         * <p>
         * The unique identifier for the client request. Use a different token for different meetings.
         * </p>
         * 
         * @param clientRequestToken
         *        The unique identifier for the client request. Use a different token for different meetings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param meetingHostId
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meetingHostId(String meetingHostId);

        /**
         * <p>
         * The Region in which to create the meeting. Available values: <code>ap-northeast-1</code>,
         * <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
         * <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>,
         * <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>,
         * <code>us-west-1</code>, <code>us-west-2</code>.
         * </p>
         * 
         * @param mediaRegion
         *        The Region in which to create the meeting. Available values: <code>ap-northeast-1</code>,
         *        <code>ap-southeast-1</code>, <code>ap-southeast-2</code>, <code>ca-central-1</code>,
         *        <code>eu-central-1</code>, <code>eu-north-1</code>, <code>eu-west-1</code>, <code>eu-west-2</code>,
         *        <code>eu-west-3</code>, <code>sa-east-1</code>, <code>us-east-1</code>, <code>us-east-2</code>,
         *        <code>us-west-1</code>, <code>us-west-2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaRegion(String mediaRegion);

        /**
         * <p>
         * The configuration for resource targets to receive notifications when meeting and attendee events occur.
         * </p>
         * 
         * @param notificationsConfiguration
         *        The configuration for resource targets to receive notifications when meeting and attendee events
         *        occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationsConfiguration(MeetingNotificationConfiguration notificationsConfiguration);

        /**
         * <p>
         * The configuration for resource targets to receive notifications when meeting and attendee events occur.
         * </p>
         * This is a convenience that creates an instance of the {@link MeetingNotificationConfiguration.Builder}
         * avoiding the need to create one manually via {@link MeetingNotificationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MeetingNotificationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationsConfiguration(MeetingNotificationConfiguration)}
         * .
         * 
         * @param notificationsConfiguration
         *        a consumer that will call methods on {@link MeetingNotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationsConfiguration(MeetingNotificationConfiguration)
         */
        default Builder notificationsConfiguration(Consumer<MeetingNotificationConfiguration.Builder> notificationsConfiguration) {
            return notificationsConfiguration(MeetingNotificationConfiguration.builder()
                    .applyMutation(notificationsConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String meetingHostId;

        private String mediaRegion;

        private MeetingNotificationConfiguration notificationsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMeetingRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            meetingHostId(model.meetingHostId);
            mediaRegion(model.mediaRegion);
            notificationsConfiguration(model.notificationsConfiguration);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getMeetingHostId() {
            return meetingHostId;
        }

        @Override
        public final Builder meetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
            return this;
        }

        public final void setMeetingHostId(String meetingHostId) {
            this.meetingHostId = meetingHostId;
        }

        public final String getMediaRegion() {
            return mediaRegion;
        }

        @Override
        public final Builder mediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
            return this;
        }

        public final void setMediaRegion(String mediaRegion) {
            this.mediaRegion = mediaRegion;
        }

        public final MeetingNotificationConfiguration.Builder getNotificationsConfiguration() {
            return notificationsConfiguration != null ? notificationsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder notificationsConfiguration(MeetingNotificationConfiguration notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration;
            return this;
        }

        public final void setNotificationsConfiguration(MeetingNotificationConfiguration.BuilderImpl notificationsConfiguration) {
            this.notificationsConfiguration = notificationsConfiguration != null ? notificationsConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMeetingRequest build() {
            return new CreateMeetingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
