/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chatbot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chatbot.ChatbotAsyncClient;
import software.amazon.awssdk.services.chatbot.internal.UserAgentUtils;
import software.amazon.awssdk.services.chatbot.model.ChimeWebhookConfiguration;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsRequest;
import software.amazon.awssdk.services.chatbot.model.DescribeChimeWebhookConfigurationsResponse;

public class DescribeChimeWebhookConfigurationsPublisher
implements SdkPublisher<DescribeChimeWebhookConfigurationsResponse> {
    private final ChatbotAsyncClient client;
    private final DescribeChimeWebhookConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeChimeWebhookConfigurationsPublisher(ChatbotAsyncClient client, DescribeChimeWebhookConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeChimeWebhookConfigurationsPublisher(ChatbotAsyncClient client, DescribeChimeWebhookConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeChimeWebhookConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeChimeWebhookConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChimeWebhookConfiguration> webhookConfigurations() {
        Function<DescribeChimeWebhookConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.webhookConfigurations() != null) {
                return response.webhookConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeChimeWebhookConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeChimeWebhookConfigurationsResponseFetcher
    implements AsyncPageFetcher<DescribeChimeWebhookConfigurationsResponse> {
        private DescribeChimeWebhookConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeChimeWebhookConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeChimeWebhookConfigurationsResponse> nextPage(DescribeChimeWebhookConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeChimeWebhookConfigurationsPublisher.this.client.describeChimeWebhookConfigurations(DescribeChimeWebhookConfigurationsPublisher.this.firstRequest);
            }
            return DescribeChimeWebhookConfigurationsPublisher.this.client.describeChimeWebhookConfigurations((DescribeChimeWebhookConfigurationsRequest)((Object)DescribeChimeWebhookConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

