/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of node configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeConfigurationOption implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeConfigurationOption.Builder, NodeConfigurationOption> {
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(NodeConfigurationOption::nodeType)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfNodes").getter(getter(NodeConfigurationOption::numberOfNodes))
            .setter(setter(Builder::numberOfNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()).build();

    private static final SdkField<Double> ESTIMATED_DISK_UTILIZATION_PERCENT_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("EstimatedDiskUtilizationPercent")
            .getter(getter(NodeConfigurationOption::estimatedDiskUtilizationPercent))
            .setter(setter(Builder::estimatedDiskUtilizationPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedDiskUtilizationPercent")
                    .build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(NodeConfigurationOption::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_TYPE_FIELD,
            NUMBER_OF_NODES_FIELD, ESTIMATED_DISK_UTILIZATION_PERCENT_FIELD, MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nodeType;

    private final Integer numberOfNodes;

    private final Double estimatedDiskUtilizationPercent;

    private final String mode;

    private NodeConfigurationOption(BuilderImpl builder) {
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.estimatedDiskUtilizationPercent = builder.estimatedDiskUtilizationPercent;
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The node type, such as, "ds2.8xlarge".
     * </p>
     * 
     * @return The node type, such as, "ds2.8xlarge".
     */
    public final String nodeType() {
        return nodeType;
    }

    /**
     * <p>
     * The number of nodes.
     * </p>
     * 
     * @return The number of nodes.
     */
    public final Integer numberOfNodes() {
        return numberOfNodes;
    }

    /**
     * <p>
     * The estimated disk utilizaton percentage.
     * </p>
     * 
     * @return The estimated disk utilizaton percentage.
     */
    public final Double estimatedDiskUtilizationPercent() {
        return estimatedDiskUtilizationPercent;
    }

    /**
     * <p>
     * The category of the node configuration recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The category of the node configuration recommendation.
     * @see Mode
     */
    public final Mode mode() {
        return Mode.fromValue(mode);
    }

    /**
     * <p>
     * The category of the node configuration recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The category of the node configuration recommendation.
     * @see Mode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedDiskUtilizationPercent());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeConfigurationOption)) {
            return false;
        }
        NodeConfigurationOption other = (NodeConfigurationOption) obj;
        return Objects.equals(nodeType(), other.nodeType()) && Objects.equals(numberOfNodes(), other.numberOfNodes())
                && Objects.equals(estimatedDiskUtilizationPercent(), other.estimatedDiskUtilizationPercent())
                && Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeConfigurationOption").add("NodeType", nodeType()).add("NumberOfNodes", numberOfNodes())
                .add("EstimatedDiskUtilizationPercent", estimatedDiskUtilizationPercent()).add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeType()));
        case "NumberOfNodes":
            return Optional.ofNullable(clazz.cast(numberOfNodes()));
        case "EstimatedDiskUtilizationPercent":
            return Optional.ofNullable(clazz.cast(estimatedDiskUtilizationPercent()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeConfigurationOption, T> g) {
        return obj -> g.apply((NodeConfigurationOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeConfigurationOption> {
        /**
         * <p>
         * The node type, such as, "ds2.8xlarge".
         * </p>
         * 
         * @param nodeType
         *        The node type, such as, "ds2.8xlarge".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * The number of nodes.
         * </p>
         * 
         * @param numberOfNodes
         *        The number of nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfNodes(Integer numberOfNodes);

        /**
         * <p>
         * The estimated disk utilizaton percentage.
         * </p>
         * 
         * @param estimatedDiskUtilizationPercent
         *        The estimated disk utilizaton percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedDiskUtilizationPercent(Double estimatedDiskUtilizationPercent);

        /**
         * <p>
         * The category of the node configuration recommendation.
         * </p>
         * 
         * @param mode
         *        The category of the node configuration recommendation.
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The category of the node configuration recommendation.
         * </p>
         * 
         * @param mode
         *        The category of the node configuration recommendation.
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(Mode mode);
    }

    static final class BuilderImpl implements Builder {
        private String nodeType;

        private Integer numberOfNodes;

        private Double estimatedDiskUtilizationPercent;

        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeConfigurationOption model) {
            nodeType(model.nodeType);
            numberOfNodes(model.numberOfNodes);
            estimatedDiskUtilizationPercent(model.estimatedDiskUtilizationPercent);
            mode(model.mode);
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final Double getEstimatedDiskUtilizationPercent() {
            return estimatedDiskUtilizationPercent;
        }

        public final void setEstimatedDiskUtilizationPercent(Double estimatedDiskUtilizationPercent) {
            this.estimatedDiskUtilizationPercent = estimatedDiskUtilizationPercent;
        }

        @Override
        public final Builder estimatedDiskUtilizationPercent(Double estimatedDiskUtilizationPercent) {
            this.estimatedDiskUtilizationPercent = estimatedDiskUtilizationPercent;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public NodeConfigurationOption build() {
            return new NodeConfigurationOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
